/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.vector.complex.MapUtility;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;

public class MappifyUtility {
    public static final String fieldKey = "key";
    public static final String fieldValue = "value";

    public static DrillBuf mappify(FieldReader reader, BaseWriter.ComplexWriter writer, DrillBuf buffer, String caller) {
        if (reader.getType().getMode() == TypeProtos.DataMode.REPEATED || reader.isSet() && reader.getType().getMinorType() != TypeProtos.MinorType.MAP) {
            throw new DrillRuntimeException("kvgen function only supports Simple maps as input");
        }
        BaseWriter.ListWriter listWriter = writer.rootAsList();
        listWriter.startList();
        BaseWriter.MapWriter mapWriter = listWriter.map();
        if (!reader.isSet()) {
            listWriter.endList();
            return buffer;
        }
        for (String str : reader) {
            FieldReader fieldReader = reader.reader(str);
            if (!fieldReader.isSet()) {
                mapWriter.end();
                continue;
            }
            mapWriter.start();
            VarCharHolder vh = new VarCharHolder();
            byte[] b = str.getBytes(Charsets.UTF_8);
            buffer = buffer.reallocIfNeeded(b.length);
            buffer.setBytes(0, b);
            vh.start = 0;
            vh.end = b.length;
            vh.buffer = buffer;
            mapWriter.varChar(fieldKey).write(vh);
            MapUtility.writeToMapFromReader(fieldReader, mapWriter, caller);
            mapWriter.end();
        }
        listWriter.endList();
        return buffer;
    }

    public static void createRepeatedMapOrList(FieldReader reader, BaseWriter.ComplexWriter writer, String caller) {
        if (TypeProtos.DataMode.REPEATED != reader.getType().getMode()) {
            throw new DrillRuntimeException("Do not invoke createRepeatedMapOrList() unless MINOR mode is REPEATED");
        }
        BaseWriter.ListWriter listWriter = writer.rootAsList();
        MapUtility.writeToListFromReader(reader, listWriter, caller);
    }

    public static void createMap(FieldReader reader, BaseWriter.ComplexWriter writer, String caller) {
        if (TypeProtos.DataMode.REPEATED == reader.getType().getMode()) {
            throw new DrillRuntimeException("Do not invoke createMap() with REPEATED MINOR mode");
        }
        if (reader.getType().getMinorType() == TypeProtos.MinorType.MAP) {
            BaseWriter.MapWriter mapWriter = writer.rootAsMap();
            for (String field : reader) {
                FieldReader fieldReader = reader.reader(field);
                MapUtility.writeToMapFromReader(fieldReader, mapWriter, field, caller);
            }
        }
    }

    public static void createList(FieldReader reader, BaseWriter.ComplexWriter writer, String caller) {
        BaseWriter.ListWriter listWriter = writer.rootAsList();
        MapUtility.writeToListFromReader(reader, listWriter, caller);
    }
}

