/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

public class MathFunctions {

    @FunctionTemplate(name="pi", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Pi
    implements DrillSimpleFunc {
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.PI;
        }
    }

    @FunctionTemplate(name="convertNullableVarCharToNumber", scope=FunctionTemplate.FunctionScope.SIMPLE, isInternal=true)
    public static class ToNullableNumberNullableInput
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder left;
        @Param
        VarCharHolder right;
        @Workspace
        DecimalFormat inputFormat;
        @Workspace
        int decimalDigits;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            byte[] buf = new byte[this.right.end - this.right.start];
            this.right.buffer.getBytes(this.right.start, buf, 0, this.right.end - this.right.start);
            this.inputFormat = new DecimalFormat(new String(buf));
            this.decimalDigits = this.inputFormat.getMaximumFractionDigits();
        }

        @Override
        public void eval() {
            if (this.left.isSet == 0 || this.left.start == this.left.end) {
                this.out.isSet = 0;
                return;
            }
            this.out.isSet = 1;
            byte[] buf1 = new byte[this.left.end - this.left.start];
            this.left.buffer.getBytes(this.left.start, buf1, 0, this.left.end - this.left.start);
            String input = new String(buf1);
            try {
                this.out.value = this.inputFormat.parse(input).doubleValue();
            }
            catch (ParseException e) {
                throw new UnsupportedOperationException("Cannot parse input: " + input + " with pattern : " + this.inputFormat.toPattern());
            }
            BigDecimal roundedValue = new BigDecimal(this.out.value);
            this.out.value = roundedValue.setScale(this.decimalDigits, 4).doubleValue();
        }
    }

    @FunctionTemplate(name="convertVarCharToNumber", scope=FunctionTemplate.FunctionScope.SIMPLE, isInternal=true)
    public static class ToNullableNumber
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        VarCharHolder right;
        @Workspace
        DecimalFormat inputFormat;
        @Workspace
        int decimalDigits;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            byte[] buf = new byte[this.right.end - this.right.start];
            this.right.buffer.getBytes(this.right.start, buf, 0, this.right.end - this.right.start);
            this.inputFormat = new DecimalFormat(new String(buf));
            this.decimalDigits = this.inputFormat.getMaximumFractionDigits();
        }

        @Override
        public void eval() {
            if (this.left.start == this.left.end) {
                this.out.isSet = 0;
                return;
            }
            this.out.isSet = 1;
            byte[] buf1 = new byte[this.left.end - this.left.start];
            this.left.buffer.getBytes(this.left.start, buf1, 0, this.left.end - this.left.start);
            String input = new String(buf1);
            try {
                this.out.value = this.inputFormat.parse(input).doubleValue();
            }
            catch (ParseException e) {
                throw new UnsupportedOperationException("Cannot parse input: " + input + " with pattern : " + this.inputFormat.toPattern());
            }
            BigDecimal roundedValue = new BigDecimal(this.out.value);
            this.out.value = roundedValue.setScale(this.decimalDigits, 4).doubleValue();
        }
    }

    @FunctionTemplate(name="to_number", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ToNumber
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        VarCharHolder right;
        @Workspace
        DecimalFormat inputFormat;
        @Workspace
        int decimalDigits;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            byte[] buf = new byte[this.right.end - this.right.start];
            this.right.buffer.getBytes(this.right.start, buf, 0, this.right.end - this.right.start);
            this.inputFormat = new DecimalFormat(new String(buf));
            this.decimalDigits = this.inputFormat.getMaximumFractionDigits();
        }

        @Override
        public void eval() {
            byte[] buf1 = new byte[this.left.end - this.left.start];
            this.left.buffer.getBytes(this.left.start, buf1, 0, this.left.end - this.left.start);
            String input = new String(buf1);
            try {
                this.out.value = this.inputFormat.parse(input).doubleValue();
            }
            catch (ParseException e) {
                throw new UnsupportedOperationException("Cannot parse input: " + input + " with pattern : " + this.inputFormat.toPattern());
            }
            BigDecimal roundedValue = new BigDecimal(this.out.value);
            this.out.value = roundedValue.setScale(this.decimalDigits, 4).doubleValue();
        }
    }

    @FunctionTemplate(name="rand", isRandom=true, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RandomWithSeed
    implements DrillSimpleFunc {
        @Param
        BigIntHolder seed;
        @Workspace
        java.util.Random rand;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.rand = new java.util.Random(this.seed.value);
        }

        @Override
        public void eval() {
            this.out.value = this.rand.nextDouble();
        }
    }

    @FunctionTemplate(name="rand", isRandom=true, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RandomWithoutSeed
    implements DrillSimpleFunc {
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.random();
        }
    }

    @FunctionTemplate(name="random", isRandom=true, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Random
    implements DrillSimpleFunc {
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.random();
        }
    }

    @FunctionTemplate(name="power", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Power
    implements DrillSimpleFunc {
        @Param
        Float8Holder a;
        @Param
        Float8Holder b;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.pow(this.a.value, this.b.value);
        }
    }
}

