/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.hadoop.fs.Path;

@FunctionTemplate(name="parentPath", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, isInternal=true)
public class ParentPathFunction
implements DrillSimpleFunc {
    @Param
    VarCharHolder input;
    @Output
    VarCharHolder out;
    @Inject
    DrillBuf buf;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        Path path = new Path(DrillStringUtils.toBinaryString(this.input.buffer, this.input.start, this.input.end));
        byte[] bytes = path.getParent().toUri().getPath().getBytes(StandardCharsets.UTF_8);
        this.buf = this.buf.reallocIfNeeded(bytes.length);
        this.buf.setBytes(0, bytes);
        this.out.buffer = this.buf;
        this.out.start = 0;
        this.out.end = bytes.length;
    }
}

