/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.physical.impl.scan.v3.FixedReceiver;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.resolver.TypeCastRules;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public class SchemaFunctions {
    public static TupleMetadata getTupleMetadata(String serialized) {
        return TupleMetadata.of(serialized);
    }

    @FunctionTemplate(name="merge_schema", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, isInternal=true)
    public static class MergeSchemaFunction
    implements DrillAggFunc {
        @Param
        VarCharHolder input;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buf;
        @Workspace
        ObjectHolder schemaHolder;

        @Override
        public void setup() {
            this.schemaHolder = new ObjectHolder();
        }

        @Override
        public void add() {
            TupleMetadata currentSchema = SchemaFunctions.getTupleMetadata(DrillStringUtils.toBinaryString(this.input.buffer, this.input.start, this.input.end));
            if (this.schemaHolder.obj == null) {
                this.schemaHolder.obj = currentSchema;
                return;
            }
            TupleMetadata resolvedSchema = (TupleMetadata)this.schemaHolder.obj;
            if (!resolvedSchema.isEquivalent(currentSchema)) {
                this.schemaHolder.obj = FixedReceiver.Builder.mergeSchemas(currentSchema, resolvedSchema);
            }
        }

        @Override
        public void output() {
            TupleMetadata resolvedSchema = (TupleMetadata)this.schemaHolder.obj;
            byte[] type = resolvedSchema.jsonString().getBytes(StandardCharsets.UTF_8);
            this.buf = this.buf.reallocIfNeeded(type.length);
            this.buf.setBytes(0, type);
            this.out.buffer = this.buf;
            this.out.start = 0;
            this.out.end = type.length;
        }

        @Override
        public void reset() {
            this.schemaHolder.obj = null;
        }
    }

    @FunctionTemplate(name="merge_schema", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, isInternal=true)
    public static class MergeNullableSchemaFunction
    implements DrillAggFunc {
        @Param
        NullableVarCharHolder input;
        @Output
        NullableVarCharHolder out;
        @Inject
        DrillBuf buf;
        @Workspace
        ObjectHolder schemaHolder;

        @Override
        public void setup() {
            this.schemaHolder = new ObjectHolder();
        }

        @Override
        public void add() {
            if (this.input.isSet == 0) {
                return;
            }
            TupleMetadata currentSchema = SchemaFunctions.getTupleMetadata(StringFunctionHelpers.toStringFromUTF8(this.input.start, this.input.end, this.input.buffer));
            if (this.schemaHolder.obj == null) {
                this.schemaHolder.obj = currentSchema;
                return;
            }
            TupleMetadata resolvedSchema = (TupleMetadata)this.schemaHolder.obj;
            if (!resolvedSchema.isEquivalent(currentSchema)) {
                this.schemaHolder.obj = FixedReceiver.Builder.mergeSchemas(currentSchema, resolvedSchema);
            }
        }

        @Override
        public void output() {
            TupleMetadata resolvedSchema = (TupleMetadata)this.schemaHolder.obj;
            byte[] type = resolvedSchema.jsonString().getBytes(StandardCharsets.UTF_8);
            this.buf = this.buf.reallocIfNeeded(type.length);
            this.buf.setBytes(0, type);
            this.out.buffer = this.buf;
            this.out.start = 0;
            this.out.end = type.length;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.schemaHolder.obj = null;
        }
    }

    @FunctionTemplate(name="schema", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, isInternal=true, isVarArg=true)
    public static class SchemaFunction
    implements DrillAggFunc {
        @Param
        FieldReader[] inputs;
        @Output
        NullableVarCharHolder out;
        @Inject
        DrillBuf buf;
        @Workspace
        ObjectHolder columnsHolder;

        @Override
        public void setup() {
            this.columnsHolder = new ObjectHolder();
        }

        @Override
        public void add() {
            if (this.columnsHolder.obj == null) {
                this.columnsHolder.obj = new LinkedHashMap();
            }
            Map columns = (Map)this.columnsHolder.obj;
            for (int i = 0; i < this.inputs.length; i += 2) {
                String columnName = this.inputs[i].readObject().toString();
                MaterializedField materializedField = (MaterializedField)columns.get(columnName);
                TypeProtos.MajorType type = this.inputs[i + 1].getType();
                if (materializedField != null && !materializedField.getType().equals(type)) {
                    TypeProtos.MinorType leastRestrictiveType = TypeCastRules.getLeastRestrictiveType(materializedField.getType().getMinorType(), type.getMinorType());
                    TypeProtos.DataMode leastRestrictiveMode = TypeCastRules.getLeastRestrictiveDataMode(materializedField.getType().getMode(), type.getMode());
                    MaterializedField clone = materializedField.clone();
                    clone.replaceType(materializedField.getType().toBuilder().setMinorType(leastRestrictiveType).setMode(leastRestrictiveMode).build());
                    columns.put(columnName, clone);
                    continue;
                }
                if (type.getMinorType() == TypeProtos.MinorType.MAP) {
                    columns.put(columnName, this.inputs[i + 1].getField());
                    continue;
                }
                columns.put(columnName, MaterializedField.create(columnName, type));
            }
        }

        @Override
        public void output() {
            SchemaBuilder schemaBuilder = new SchemaBuilder();
            Map columns = (Map)this.columnsHolder.obj;
            if (columns == null) {
                return;
            }
            for (MaterializedField materializedField : columns.values()) {
                schemaBuilder.add(materializedField);
            }
            byte[] type = schemaBuilder.build().jsonString().getBytes(StandardCharsets.UTF_8);
            this.buf = this.buf.reallocIfNeeded(type.length);
            this.buf.setBytes(0, type);
            this.out.buffer = this.buf;
            this.out.start = 0;
            this.out.end = type.length;
            this.out.isSet = 1;
        }

        @Override
        public void reset() {
            this.columnsHolder.obj = null;
        }
    }
}

