/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import com.google.common.base.Charsets;
import io.netty.buffer.DrillBuf;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.drill.common.types.BooleanType;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

public class SimpleCastFunctions {

    @FunctionTemplate(name="castVARCHAR", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.STRING_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class CastBooleanVarChar
    implements DrillSimpleFunc {
        @Param
        BitHolder in;
        @Param
        BigIntHolder len;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            byte[] outB = BooleanType.get(String.valueOf(this.in.value)).name().toLowerCase().getBytes(StandardCharsets.UTF_8);
            this.buffer.setBytes(0, outB);
            this.out.buffer = this.buffer;
            this.out.start = 0;
            this.out.end = Math.min((int)this.len.value, outB.length);
        }
    }

    @FunctionTemplate(names={"castBIT", "castBOOLEAN"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastVarCharBoolean
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            byte[] buf = new byte[this.in.end - this.in.start];
            this.in.buffer.getBytes(this.in.start, buf, 0, this.in.end - this.in.start);
            String input = new String(buf, Charsets.UTF_8);
            this.out.value = BooleanType.get(input).getNumericValue();
        }
    }
}

