/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.CharSequenceWrapper;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.RepeatedBigIntHolder;
import org.apache.drill.exec.expr.holders.RepeatedBitHolder;
import org.apache.drill.exec.expr.holders.RepeatedFloat4Holder;
import org.apache.drill.exec.expr.holders.RepeatedFloat8Holder;
import org.apache.drill.exec.expr.holders.RepeatedIntHolder;
import org.apache.drill.exec.expr.holders.RepeatedTinyIntHolder;
import org.apache.drill.exec.expr.holders.RepeatedVarCharHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

public class SimpleRepeatedFunctions {
    private SimpleRepeatedFunctions() {
    }

    @FunctionTemplate(name="repeated_contains", scope=FunctionTemplate.FunctionScope.SIMPLE)
    public static class ContainsVarChar
    implements DrillSimpleFunc {
        @Param
        RepeatedVarCharHolder listToSearch;
        @Param
        VarCharHolder targetValue;
        @Workspace
        VarCharHolder currVal;
        @Workspace
        Matcher matcher;
        @Workspace
        CharSequenceWrapper charSequenceWrapper;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.currVal = new VarCharHolder();
            this.matcher = Pattern.compile(StringFunctionHelpers.toStringFromUTF8(this.targetValue.start, this.targetValue.end, this.targetValue.buffer)).matcher("");
            this.charSequenceWrapper = new CharSequenceWrapper();
            this.matcher.reset(this.charSequenceWrapper);
        }

        @Override
        public void eval() {
            for (int i = this.listToSearch.start; i < this.listToSearch.end; ++i) {
                this.out.value = 0;
                this.listToSearch.vector.getAccessor().get(i, this.currVal);
                this.charSequenceWrapper.setBuffer(this.currVal.start, this.currVal.end, this.currVal.buffer);
                this.matcher.reset();
                if (!this.matcher.find()) continue;
                this.out.value = 1;
                break;
            }
        }
    }

    @FunctionTemplate(name="repeated_contains", scope=FunctionTemplate.FunctionScope.SIMPLE)
    public static class ContainsFloat8
    implements DrillSimpleFunc {
        @Param
        RepeatedFloat8Holder listToSearch;
        @Param
        Float8Holder targetValue;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0;
            for (int i = this.listToSearch.start; i < this.listToSearch.end; ++i) {
                if (this.listToSearch.vector.getAccessor().get(i) != this.targetValue.value) continue;
                this.out.value = 1;
                break;
            }
        }
    }

    @FunctionTemplate(name="repeated_contains", scope=FunctionTemplate.FunctionScope.SIMPLE)
    public static class ContainsFloat4
    implements DrillSimpleFunc {
        @Param
        RepeatedFloat4Holder listToSearch;
        @Param
        Float4Holder targetValue;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0;
            for (int i = this.listToSearch.start; i < this.listToSearch.end; ++i) {
                if (this.listToSearch.vector.getAccessor().get(i) != this.targetValue.value) continue;
                this.out.value = 1;
                break;
            }
        }
    }

    @FunctionTemplate(name="repeated_contains", scope=FunctionTemplate.FunctionScope.SIMPLE)
    public static class ContainsBit
    implements DrillSimpleFunc {
        @Param
        RepeatedBitHolder listToSearch;
        @Param
        BitHolder targetValue;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0;
            for (int i = this.listToSearch.start; i < this.listToSearch.end; ++i) {
                if (this.listToSearch.vector.getAccessor().get(i) != this.targetValue.value) continue;
                this.out.value = 1;
                break;
            }
        }
    }

    @FunctionTemplate(name="repeated_contains", scope=FunctionTemplate.FunctionScope.SIMPLE)
    public static class ContainsTinyInt
    implements DrillSimpleFunc {
        @Param
        RepeatedTinyIntHolder listToSearch;
        @Param
        TinyIntHolder targetValue;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            for (int i = this.listToSearch.start; i < this.listToSearch.end; ++i) {
                if (this.listToSearch.vector.getAccessor().get(i) != this.targetValue.value) continue;
                this.out.value = 1;
                break;
            }
        }
    }

    @FunctionTemplate(name="repeated_contains", scope=FunctionTemplate.FunctionScope.SIMPLE)
    public static class ContainsInt
    implements DrillSimpleFunc {
        @Param
        RepeatedIntHolder listToSearch;
        @Param
        IntHolder targetValue;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0;
            for (int i = this.listToSearch.start; i < this.listToSearch.end; ++i) {
                if (this.listToSearch.vector.getAccessor().get(i) != this.targetValue.value) continue;
                this.out.value = 1;
                break;
            }
        }
    }

    @FunctionTemplate(name="repeated_contains", scope=FunctionTemplate.FunctionScope.SIMPLE)
    public static class ContainsBigInt
    implements DrillSimpleFunc {
        @Param
        RepeatedBigIntHolder listToSearch;
        @Param
        BigIntHolder targetValue;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0;
            for (int i = this.listToSearch.start; i < this.listToSearch.end; ++i) {
                if (this.listToSearch.vector.getAccessor().get(i) != this.targetValue.value) continue;
                this.out.value = 1;
                break;
            }
        }
    }
}

