/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import io.netty.buffer.DrillBuf;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.CharSequenceWrapper;
import org.apache.drill.exec.expr.fn.impl.RegexpUtil;
import org.apache.drill.exec.expr.fn.impl.SqlPatternFactory;
import org.apache.drill.exec.expr.fn.impl.SqlPatternMatcher;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.fn.impl.StringFunctionUtil;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.VarCharWriter;

public class StringFunctions {
    private StringFunctions() {
    }

    @FunctionTemplate(name="reverse", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.SAME_IN_OUT_LENGTH, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CLONE)
    public static class ReverseString
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int charLen;
            int len = this.in.end - this.in.start;
            this.out.start = 0;
            this.out.end = len;
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
            int index = this.out.end;
            for (int id = this.in.start; id < this.in.end; id += charLen) {
                for (int innerIndex = charLen = StringFunctionUtil.utf8CharLen(this.in.buffer, id); innerIndex > 0; --innerIndex) {
                    this.out.buffer.setByte(index - innerIndex, this.in.buffer.getByte(id + (charLen - innerIndex)));
                }
                index -= charLen;
            }
        }
    }

    @FunctionTemplate(name="toascii", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class AsciiEndode
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Param
        VarCharHolder enc;
        @Output
        VarCharHolder out;
        @Workspace
        Charset inCharset;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
            this.inCharset = Charset.forName(StringFunctionHelpers.toStringFromUTF8(this.enc.start, this.enc.end, this.enc.buffer));
        }

        @Override
        public void eval() {
            byte[] bytea = new byte[this.in.end - this.in.start];
            int index = 0;
            int i = this.in.start;
            while (i < this.in.end) {
                bytea[index] = this.in.buffer.getByte(i);
                ++i;
                ++index;
            }
            byte[] outBytea = new String(bytea, this.inCharset).getBytes(Charsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(outBytea.length);
            this.out.buffer.setBytes(0, outBytea);
            this.out.start = 0;
            this.out.end = outBytea.length;
        }
    }

    @FunctionTemplate(names={"repeat", "repeatstr"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_FIXED_WIDTH_DEFAULT)
    public static class RepeatString
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Param
        IntHolder nTimes;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int len = this.in.end - this.in.start;
            int num = this.nTimes.value;
            this.out.start = 0;
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(len * num);
            for (int i = 0; i < num; ++i) {
                this.in.buffer.getBytes(this.in.start, this.out.buffer, i * len, len);
            }
            this.out.end = len * num;
        }
    }

    @FunctionTemplate(name="chr", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputSizeEstimate=1)
    public static class AsciiToChar
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
            this.buf = this.buf.reallocIfNeeded(1);
        }

        @Override
        public void eval() {
            this.out.buffer = this.buf;
            this.out.end = 0;
            this.out.start = 0;
            this.out.buffer.setByte(0, this.in.value);
            ++this.out.end;
        }
    }

    @FunctionTemplate(name="ascii", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AsciiString
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.buffer.getByte(this.in.start);
        }
    }

    @FunctionTemplate(name="string_binary", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class StringBinary
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder in;
        @Output
        VarCharHolder out;
        @Workspace
        Charset charset;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
            this.charset = StandardCharsets.UTF_8;
        }

        @Override
        public void eval() {
            byte[] buf = DrillStringUtils.toBinaryString(this.in.buffer, this.in.start, this.in.end).getBytes(this.charset);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(buf.length);
            this.out.buffer.setBytes(0, buf);
            this.out.buffer.setIndex(0, buf.length);
            this.out.start = 0;
            this.out.end = buf.length;
        }
    }

    @FunctionTemplate(name="binary_string", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class BinaryString
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Output
        VarBinaryHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(this.in.end - this.in.start);
            this.out.end = 0;
            this.out.start = 0;
            this.out.end = DrillStringUtils.parseBinaryString(this.in.buffer, this.in.start, this.in.end, this.out.buffer);
            this.out.buffer.setIndex(this.out.start, this.out.end);
        }
    }

    @FunctionTemplate(name="concat", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.CONCAT, nulls=FunctionTemplate.NullHandling.INTERNAL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CONCAT)
    public static class ConcatBothNullInput
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder left;
        @Param
        NullableVarCharHolder right;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (this.left.isSet == 1 && this.right.isSet == 1) {
                int id;
                this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(this.left.end - this.left.start + (this.right.end - this.right.start));
                this.out.end = 0;
                this.out.start = 0;
                for (id = this.left.start; id < this.left.end; ++id) {
                    this.out.buffer.setByte(this.out.end++, this.left.buffer.getByte(id));
                }
                for (id = this.right.start; id < this.right.end; ++id) {
                    this.out.buffer.setByte(this.out.end++, this.right.buffer.getByte(id));
                }
            } else if (this.left.isSet == 1) {
                this.out.buffer = this.left.buffer;
                this.out.start = this.left.start;
                this.out.end = this.left.end;
            } else if (this.right.isSet == 1) {
                this.out.buffer = this.right.buffer;
                this.out.start = this.right.start;
                this.out.end = this.right.end;
            } else {
                this.out.buffer = this.buffer;
                this.out.end = 0;
                this.out.start = 0;
            }
        }
    }

    @FunctionTemplate(name="concat", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.CONCAT, nulls=FunctionTemplate.NullHandling.INTERNAL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CONCAT)
    public static class ConcatLeftNullInput
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder left;
        @Param
        VarCharHolder right;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (this.left.isSet == 1) {
                int id;
                this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(this.left.end - this.left.start + (this.right.end - this.right.start));
                this.out.end = 0;
                this.out.start = 0;
                for (id = this.left.start; id < this.left.end; ++id) {
                    this.out.buffer.setByte(this.out.end++, this.left.buffer.getByte(id));
                }
                for (id = this.right.start; id < this.right.end; ++id) {
                    this.out.buffer.setByte(this.out.end++, this.right.buffer.getByte(id));
                }
            } else {
                this.out.buffer = this.right.buffer;
                this.out.start = this.right.start;
                this.out.end = this.right.end;
            }
        }
    }

    @FunctionTemplate(name="concat", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.CONCAT, nulls=FunctionTemplate.NullHandling.INTERNAL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CONCAT)
    public static class ConcatRightNullInput
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        NullableVarCharHolder right;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (this.right.isSet == 1) {
                int id;
                this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(this.left.end - this.left.start + (this.right.end - this.right.start));
                this.out.end = 0;
                this.out.start = 0;
                for (id = this.left.start; id < this.left.end; ++id) {
                    this.out.buffer.setByte(this.out.end++, this.left.buffer.getByte(id));
                }
                for (id = this.right.start; id < this.right.end; ++id) {
                    this.out.buffer.setByte(this.out.end++, this.right.buffer.getByte(id));
                }
            } else {
                this.out.buffer = this.left.buffer;
                this.out.start = this.left.start;
                this.out.end = this.left.end;
            }
        }
    }

    @FunctionTemplate(name="concat", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.CONCAT, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CONCAT, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class Concat
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        VarCharHolder right;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(this.left.end - this.left.start + (this.right.end - this.right.start));
            this.out.end = 0;
            this.out.start = 0;
            int id = 0;
            for (id = this.left.start; id < this.left.end; ++id) {
                this.out.buffer.setByte(this.out.end++, this.left.buffer.getByte(id));
            }
            for (id = this.right.start; id < this.right.end; ++id) {
                this.out.buffer.setByte(this.out.end++, this.right.buffer.getByte(id));
            }
        }
    }

    @FunctionTemplate(name="concatOperator", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.CONCAT, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CONCAT)
    public static class ConcatOperator
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        VarCharHolder right;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int id;
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(this.left.end - this.left.start + (this.right.end - this.right.start));
            this.out.end = 0;
            this.out.start = 0;
            for (id = this.left.start; id < this.left.end; ++id) {
                this.out.buffer.setByte(this.out.end++, this.left.buffer.getByte(id));
            }
            for (id = this.right.start; id < this.right.end; ++id) {
                this.out.buffer.setByte(this.out.end++, this.right.buffer.getByte(id));
            }
        }
    }

    @FunctionTemplate(name="split", scope=FunctionTemplate.FunctionScope.SIMPLE, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_FIXED_WIDTH_DEFAULT)
    public static class SplitNullableInput
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder in;
        @Param
        VarCharHolder delimiter;
        @Workspace
        Splitter splitter;
        @Inject
        DrillBuf buffer;
        @Output
        BaseWriter.ComplexWriter writer;

        @Override
        public void setup() {
            int len = this.delimiter.end - this.delimiter.start;
            if (len != 1) {
                throw new IllegalArgumentException("Only single character delimiters are supported for split()");
            }
            char splitChar = StringFunctionHelpers.toStringFromUTF8(this.delimiter.start, this.delimiter.end, this.delimiter.buffer).charAt(0);
            this.splitter = Splitter.on(splitChar);
        }

        @Override
        public void eval() {
            Object[] tokens;
            if (this.in.isSet == 1) {
                String inputString = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer);
                tokens = Iterables.toArray(this.splitter.split(inputString), String.class);
            } else {
                tokens = new Object[]{};
            }
            BaseWriter.ListWriter list = this.writer.rootAsList();
            list.startList();
            VarCharWriter varCharWriter = list.varChar();
            for (Object token : tokens) {
                byte[] strBytes = ((String)token).getBytes(Charsets.UTF_8);
                this.buffer = this.buffer.reallocIfNeeded(strBytes.length);
                this.buffer.setBytes(0, strBytes);
                varCharWriter.writeVarChar(0, strBytes.length, this.buffer);
            }
            list.endList();
        }
    }

    @FunctionTemplate(name="btrim", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class BtrimOneArg
    implements DrillSimpleFunc {
        @Param
        VarCharHolder text;
        @Output
        VarCharHolder out;
        @Workspace
        byte spaceInByte;

        @Override
        public void setup() {
            this.spaceInByte = (byte)32;
        }

        @Override
        public void eval() {
            int id;
            this.out.buffer = this.text.buffer;
            this.out.start = this.out.end = this.text.start;
            for (id = this.text.start; id < this.text.end; ++id) {
                if (this.text.buffer.getByte(id) == this.spaceInByte) continue;
                this.out.start = id;
                break;
            }
            for (id = this.text.end - 1; id >= this.text.start; --id) {
                while ((this.text.buffer.getByte(id) & 0xC0) == 128 && id >= this.text.start) {
                    --id;
                }
                if (this.text.buffer.getByte(id) == this.spaceInByte) continue;
                this.out.end = id + 1;
                break;
            }
        }
    }

    @FunctionTemplate(name="btrim", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class Btrim
    implements DrillSimpleFunc {
        @Param
        VarCharHolder text;
        @Param
        VarCharHolder from;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int pos;
            int id;
            this.out.buffer = this.text.buffer;
            this.out.start = this.out.end = this.text.start;
            int bytePerChar = 0;
            for (id = this.text.start; id < this.text.end; id += bytePerChar) {
                bytePerChar = StringFunctionUtil.utf8CharLen(this.text.buffer, id);
                pos = StringFunctionUtil.stringLeftMatchUTF8(this.from.buffer, this.from.start, this.from.end, this.text.buffer, id, id + bytePerChar);
                if (pos >= 0) continue;
                this.out.start = id;
                break;
            }
            for (id = this.text.end - 1; id >= this.text.start; id -= bytePerChar) {
                while ((this.text.buffer.getByte(id) & 0xC0) == 128 && id >= this.text.start) {
                    --id;
                }
                bytePerChar = StringFunctionUtil.utf8CharLen(this.text.buffer, id);
                pos = StringFunctionUtil.stringLeftMatchUTF8(this.from.buffer, this.from.start, this.from.end, this.text.buffer, id, id + bytePerChar);
                if (pos >= 0) continue;
                this.out.end = id + bytePerChar;
                break;
            }
        }
    }

    @FunctionTemplate(name="rtrim", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class RtrimOneArg
    implements DrillSimpleFunc {
        @Param
        VarCharHolder text;
        @Output
        VarCharHolder out;
        @Workspace
        byte spaceInByte;

        @Override
        public void setup() {
            this.spaceInByte = (byte)32;
        }

        @Override
        public void eval() {
            this.out.buffer = this.text.buffer;
            this.out.start = this.out.end = this.text.start;
            for (int id = this.text.end - 1; id >= this.text.start; --id) {
                while ((this.text.buffer.getByte(id) & 0xC0) == 128 && id >= this.text.start) {
                    --id;
                }
                if (this.text.buffer.getByte(id) == this.spaceInByte) continue;
                this.out.end = id + 1;
                break;
            }
        }
    }

    @FunctionTemplate(name="rtrim", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class Rtrim
    implements DrillSimpleFunc {
        @Param
        VarCharHolder text;
        @Param
        VarCharHolder from;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.buffer = this.text.buffer;
            this.out.start = this.out.end = this.text.start;
            int bytePerChar = 0;
            for (int id = this.text.end - 1; id >= this.text.start; id -= bytePerChar) {
                while ((this.text.buffer.getByte(id) & 0xC0) == 128 && id >= this.text.start) {
                    --id;
                }
                bytePerChar = StringFunctionUtil.utf8CharLen(this.text.buffer, id);
                int pos = StringFunctionUtil.stringLeftMatchUTF8(this.from.buffer, this.from.start, this.from.end, this.text.buffer, id, id + bytePerChar);
                if (pos >= 0) continue;
                this.out.end = id + bytePerChar;
                break;
            }
        }
    }

    @FunctionTemplate(name="ltrim", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class LtrimOneArg
    implements DrillSimpleFunc {
        @Param
        VarCharHolder text;
        @Output
        VarCharHolder out;
        @Workspace
        byte spaceInByte;

        @Override
        public void setup() {
            this.spaceInByte = (byte)32;
        }

        @Override
        public void eval() {
            this.out.buffer = this.text.buffer;
            this.out.start = this.out.end = this.text.end;
            for (int id = this.text.start; id < this.text.end; ++id) {
                if (this.text.buffer.getByte(id) == this.spaceInByte) continue;
                this.out.start = id;
                break;
            }
        }
    }

    @FunctionTemplate(name="ltrim", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class Ltrim
    implements DrillSimpleFunc {
        @Param
        VarCharHolder text;
        @Param
        VarCharHolder from;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.buffer = this.text.buffer;
            this.out.start = this.out.end = this.text.end;
            int bytePerChar = 0;
            for (int id = this.text.start; id < this.text.end; id += bytePerChar) {
                bytePerChar = StringFunctionUtil.utf8CharLen(this.text.buffer, id);
                int pos = StringFunctionUtil.stringLeftMatchUTF8(this.from.buffer, this.from.start, this.from.end, this.text.buffer, id, id + bytePerChar);
                if (pos >= 0) continue;
                this.out.start = id;
                break;
            }
        }
    }

    @FunctionTemplate(name="rpad", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.PAD, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_FIXED_WIDTH_DEFAULT)
    public static class RpadTwoArg
    implements DrillSimpleFunc {
        @Param
        VarCharHolder text;
        @Param
        BigIntHolder length;
        @Inject
        DrillBuf buffer;
        @Output
        VarCharHolder out;
        @Workspace
        byte spaceInByte;

        @Override
        public void setup() {
            this.spaceInByte = (byte)32;
        }

        @Override
        public void eval() {
            long theLength = this.length.value;
            int lengthNeeded = (int)(theLength <= 0L ? 0L : theLength * 2L);
            this.buffer = this.buffer.reallocIfNeeded(lengthNeeded);
            int textCharCount = StringFunctionUtil.getUTF8CharLength(this.text.buffer, this.text.start, this.text.end);
            if (theLength <= 0L) {
                this.out.buffer = this.buffer;
                this.out.end = 0;
                this.out.start = 0;
            } else if (theLength == (long)textCharCount) {
                this.out.buffer = this.text.buffer;
                this.out.start = this.text.start;
                this.out.end = this.text.end;
            } else if (theLength < (long)textCharCount) {
                this.out.buffer = this.text.buffer;
                this.out.start = this.text.start;
                this.out.end = StringFunctionUtil.getUTF8CharPosition(this.text.buffer, this.text.start, this.text.end, (int)theLength);
            } else if (theLength > (long)textCharCount) {
                this.out.buffer = this.buffer;
                this.out.end = 0;
                this.out.start = 0;
                for (int id = this.text.start; id < this.text.end; ++id) {
                    this.out.buffer.setByte(this.out.end++, this.text.buffer.getByte(id));
                }
                int count = 0;
                while ((long)count < theLength - (long)textCharCount) {
                    this.out.buffer.setByte(this.out.end++, this.spaceInByte);
                    ++count;
                }
            }
        }
    }

    @FunctionTemplate(name="rpad", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.PAD, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_FIXED_WIDTH_DEFAULT)
    public static class Rpad
    implements DrillSimpleFunc {
        @Param
        VarCharHolder text;
        @Param
        BigIntHolder length;
        @Param
        VarCharHolder fill;
        @Inject
        DrillBuf buffer;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            long theLength = this.length.value;
            int lengthNeeded = (int)(theLength <= 0L ? 0L : theLength * 2L);
            this.buffer = this.buffer.reallocIfNeeded(lengthNeeded);
            byte currentByte = 0;
            int id = 0;
            int textCharCount = StringFunctionUtil.getUTF8CharLength(this.text.buffer, this.text.start, this.text.end);
            int fillCharCount = StringFunctionUtil.getUTF8CharLength(this.fill.buffer, this.fill.start, this.fill.end);
            if (theLength <= 0L) {
                this.out.buffer = this.buffer;
                this.out.end = 0;
                this.out.start = 0;
            } else if (theLength == (long)textCharCount || theLength > (long)textCharCount && fillCharCount == 0) {
                this.out.buffer = this.text.buffer;
                this.out.start = this.text.start;
                this.out.end = this.text.end;
            } else if (theLength < (long)textCharCount) {
                this.out.buffer = this.text.buffer;
                this.out.start = this.text.start;
                this.out.end = StringFunctionUtil.getUTF8CharPosition(this.text.buffer, this.text.start, this.text.end, (int)theLength);
            } else if (theLength > (long)textCharCount) {
                this.out.buffer = this.buffer;
                this.out.end = 0;
                this.out.start = 0;
                for (id = this.text.start; id < this.text.end; ++id) {
                    this.out.buffer.setByte(this.out.end++, this.text.buffer.getByte(id));
                }
                int count = 0;
                while ((long)count < theLength - (long)textCharCount) {
                    for (id = this.fill.start; id < this.fill.end && (long)count != theLength - (long)textCharCount; ++id) {
                        currentByte = this.fill.buffer.getByte(id);
                        if (currentByte < 296 || (currentByte & 0xE0) == 192 || (currentByte & 0xF0) == 224 || (currentByte & 0xF8) == 240) {
                            ++count;
                        }
                        this.out.buffer.setByte(this.out.end++, currentByte);
                    }
                }
            }
        }
    }

    @FunctionTemplate(name="lpad", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.PAD, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_FIXED_WIDTH_DEFAULT)
    public static class LpadTwoArg
    implements DrillSimpleFunc {
        @Param
        VarCharHolder text;
        @Param
        BigIntHolder length;
        @Inject
        DrillBuf buffer;
        @Output
        VarCharHolder out;
        @Workspace
        byte spaceInByte;

        @Override
        public void setup() {
            this.spaceInByte = (byte)32;
        }

        @Override
        public void eval() {
            long theLength = this.length.value;
            int lengthNeeded = (int)(theLength <= 0L ? 0L : theLength * 2L);
            this.buffer = this.buffer.reallocIfNeeded(lengthNeeded);
            int textCharCount = StringFunctionUtil.getUTF8CharLength(this.text.buffer, this.text.start, this.text.end);
            if (theLength <= 0L) {
                this.out.buffer = this.buffer;
                this.out.end = 0;
                this.out.start = 0;
            } else if (theLength == (long)textCharCount) {
                this.out.buffer = this.text.buffer;
                this.out.start = this.text.start;
                this.out.end = this.text.end;
            } else if (theLength < (long)textCharCount) {
                this.out.buffer = this.text.buffer;
                this.out.start = this.text.start;
                this.out.end = StringFunctionUtil.getUTF8CharPosition(this.text.buffer, this.text.start, this.text.end, (int)theLength);
            } else if (theLength > (long)textCharCount) {
                int count = 0;
                this.out.buffer = this.buffer;
                this.out.end = 0;
                this.out.start = 0;
                while ((long)count < theLength - (long)textCharCount) {
                    this.out.buffer.setByte(this.out.end++, this.spaceInByte);
                    ++count;
                }
                for (int id = this.text.start; id < this.text.end; ++id) {
                    this.out.buffer.setByte(this.out.end++, this.text.buffer.getByte(id));
                }
            }
        }
    }

    @FunctionTemplate(name="lpad", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.PAD, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_FIXED_WIDTH_DEFAULT)
    public static class Lpad
    implements DrillSimpleFunc {
        @Param
        VarCharHolder text;
        @Param
        BigIntHolder length;
        @Param
        VarCharHolder fill;
        @Inject
        DrillBuf buffer;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            long theLength = this.length.value;
            int lengthNeeded = (int)(theLength <= 0L ? 0L : theLength * 2L);
            this.buffer = this.buffer.reallocIfNeeded(lengthNeeded);
            byte currentByte = 0;
            int id = 0;
            int textCharCount = StringFunctionUtil.getUTF8CharLength(this.text.buffer, this.text.start, this.text.end);
            int fillCharCount = StringFunctionUtil.getUTF8CharLength(this.fill.buffer, this.fill.start, this.fill.end);
            if (theLength <= 0L) {
                this.out.buffer = this.buffer;
                this.out.end = 0;
                this.out.start = 0;
            } else if (theLength == (long)textCharCount || theLength > (long)textCharCount && fillCharCount == 0) {
                this.out.buffer = this.text.buffer;
                this.out.start = this.text.start;
                this.out.end = this.text.end;
            } else if (theLength < (long)textCharCount) {
                this.out.buffer = this.text.buffer;
                this.out.start = this.text.start;
                this.out.end = StringFunctionUtil.getUTF8CharPosition(this.text.buffer, this.text.start, this.text.end, (int)theLength);
            } else if (theLength > (long)textCharCount) {
                int count = 0;
                this.out.buffer = this.buffer;
                this.out.end = 0;
                this.out.start = 0;
                while ((long)count < theLength - (long)textCharCount) {
                    for (id = this.fill.start; id < this.fill.end && (long)count != theLength - (long)textCharCount; ++id) {
                        currentByte = this.fill.buffer.getByte(id);
                        if (currentByte < 296 || (currentByte & 0xE0) == 192 || (currentByte & 0xF0) == 224 || (currentByte & 0xF8) == 240) {
                            ++count;
                        }
                        this.out.buffer.setByte(this.out.end++, currentByte);
                    }
                }
                for (id = this.text.start; id < this.text.end; ++id) {
                    this.out.buffer.setByte(this.out.end++, this.text.buffer.getByte(id));
                }
            }
        }
    }

    @FunctionTemplate(name="replace", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class Replace
    implements DrillSimpleFunc {
        @Param
        VarCharHolder text;
        @Param
        VarCharHolder from;
        @Param
        VarCharHolder to;
        @Inject
        DrillBuf buffer;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
            this.buffer = this.buffer.reallocIfNeeded(8000);
        }

        @Override
        public void eval() {
            this.out.end = 0;
            this.out.start = 0;
            int fromL = this.from.end - this.from.start;
            int textL = this.text.end - this.text.start;
            this.out.buffer = this.buffer.capacity() < textL ? this.buffer.reallocIfNeeded(textL) : this.buffer;
            if (fromL > 0 && fromL <= textL) {
                int i = this.text.start;
                while (i <= this.text.end - fromL) {
                    int j;
                    for (j = this.from.start; j < this.from.end && this.text.buffer.getByte(i + j - this.from.start) == this.from.buffer.getByte(j); ++j) {
                    }
                    if (j == this.from.end) {
                        for (int k = this.to.start; k < this.to.end; ++k) {
                            this.out.buffer.setByte(this.out.end++, this.to.buffer.getByte(k));
                        }
                        i += this.from.end - this.from.start;
                        continue;
                    }
                    this.out.buffer.setByte(this.out.end++, this.text.buffer.getByte(i++));
                }
                while (i < this.text.end) {
                    this.out.buffer.setByte(this.out.end++, this.text.buffer.getByte(i));
                    ++i;
                }
            } else {
                this.out.buffer = this.text.buffer;
                this.out.start = this.text.start;
                this.out.end = this.text.end;
            }
        }
    }

    @FunctionTemplate(name="initcap", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.SAME_IN_OUT_LENGTH, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CLONE)
    public static class InitCap
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            String source = StringFunctionHelpers.toStringFromUTF8(this.input.start, this.input.end, this.input.buffer);
            String result = StringFunctionHelpers.initCap(source);
            byte[] bytes = result.getBytes(Charsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(bytes.length);
            this.out.start = 0;
            this.out.end = bytes.length;
            this.out.buffer.setBytes(0, bytes);
        }
    }

    @FunctionTemplate(name="right", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_FIXED_WIDTH_DEFAULT)
    public static class Right
    implements DrillSimpleFunc {
        @Param
        VarCharHolder string;
        @Param
        BigIntHolder length;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.buffer = this.string.buffer;
            if (this.length.value == 0L || this.string.end <= this.string.start) {
                this.out.end = 0;
                this.out.start = 0;
            } else {
                int charLen;
                int fromCharIdx;
                int charCount = StringFunctionUtil.getUTF8CharLength(this.string.buffer, this.string.start, this.string.end);
                if (this.length.value > 0L) {
                    fromCharIdx = Math.max(charCount - (int)this.length.value + 1, 1);
                    charLen = charCount - fromCharIdx + 1;
                } else {
                    fromCharIdx = Math.abs((int)this.length.value) + 1;
                    charLen = charCount - fromCharIdx + 1;
                }
                if (charLen <= 0) {
                    this.out.end = 0;
                    this.out.start = 0;
                } else {
                    this.out.start = StringFunctionUtil.getUTF8CharPosition(this.string.buffer, this.string.start, this.string.end, fromCharIdx - 1);
                    this.out.end = StringFunctionUtil.getUTF8CharPosition(this.string.buffer, this.out.start, this.string.end, charLen);
                }
            }
        }
    }

    @FunctionTemplate(name="left", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_FIXED_WIDTH_DEFAULT)
    public static class Left
    implements DrillSimpleFunc {
        @Param
        VarCharHolder string;
        @Param
        BigIntHolder length;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.buffer = this.string.buffer;
            if (this.length.value == 0L || this.string.end <= this.string.start) {
                this.out.end = 0;
                this.out.start = 0;
            } else {
                int charCount = StringFunctionUtil.getUTF8CharLength(this.string.buffer, this.string.start, this.string.end);
                int charLen = this.length.value > 0L ? Math.min((int)this.length.value, charCount) : (this.length.value < 0L ? Math.max(0, charCount + (int)this.length.value) : 0);
                this.out.start = this.string.start;
                this.out.end = StringFunctionUtil.getUTF8CharPosition(this.string.buffer, this.out.start, this.string.end, charLen);
            }
        }
    }

    @FunctionTemplate(names={"substring", "substr"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_FIXED_WIDTH_DEFAULT)
    public static class SubstringRegexNullable
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder input;
        @Param(constant=true)
        VarCharHolder pattern;
        @Output
        NullableVarCharHolder out;
        @Workspace
        Matcher matcher;
        @Workspace
        CharSequenceWrapper charSequenceWrapper;

        @Override
        public void setup() {
            this.matcher = Pattern.compile(StringFunctionHelpers.toStringFromUTF8(this.pattern.start, this.pattern.end, this.pattern.buffer)).matcher("");
            this.charSequenceWrapper = new CharSequenceWrapper();
            this.matcher.reset(this.charSequenceWrapper);
        }

        @Override
        public void eval() {
            if (this.input.isSet == 0) {
                this.out.isSet = 0;
            } else {
                this.charSequenceWrapper.setBuffer(this.input.start, this.input.end, this.input.buffer);
                this.matcher.reset();
                if (this.matcher.find()) {
                    this.out.isSet = 1;
                    this.out.buffer = this.input.buffer;
                    this.out.start = StringFunctionUtil.getUTF8CharPosition(this.input.buffer, this.input.start, this.input.end, this.matcher.start());
                    this.out.end = StringFunctionUtil.getUTF8CharPosition(this.input.buffer, this.input.start, this.input.end, this.matcher.end());
                } else {
                    this.out.isSet = 0;
                }
            }
        }
    }

    @FunctionTemplate(names={"substring", "substr"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class SubstringRegex
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Param(constant=true)
        VarCharHolder pattern;
        @Output
        NullableVarCharHolder out;
        @Workspace
        Matcher matcher;
        @Workspace
        CharSequenceWrapper charSequenceWrapper;

        @Override
        public void setup() {
            this.matcher = Pattern.compile(StringFunctionHelpers.toStringFromUTF8(this.pattern.start, this.pattern.end, this.pattern.buffer)).matcher("");
            this.charSequenceWrapper = new CharSequenceWrapper();
            this.matcher.reset(this.charSequenceWrapper);
        }

        @Override
        public void eval() {
            this.charSequenceWrapper.setBuffer(this.input.start, this.input.end, this.input.buffer);
            this.matcher.reset();
            if (this.matcher.find()) {
                this.out.isSet = 1;
                this.out.buffer = this.input.buffer;
                this.out.start = StringFunctionUtil.getUTF8CharPosition(this.input.buffer, this.input.start, this.input.end, this.matcher.start());
                this.out.end = StringFunctionUtil.getUTF8CharPosition(this.input.buffer, this.input.start, this.input.end, this.matcher.end());
            }
        }
    }

    @FunctionTemplate(names={"substring", "substr"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class SubstringOffset
    implements DrillSimpleFunc {
        @Param
        VarCharHolder string;
        @Param
        BigIntHolder offset;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.buffer = this.string.buffer;
            if (this.offset.value <= 0L || this.string.end <= this.string.start) {
                this.out.end = 0;
                this.out.start = 0;
            } else {
                int fromCharIdx = (int)this.offset.value;
                int charCount = StringFunctionUtil.getUTF8CharLength(this.string.buffer, this.string.start, this.string.end);
                if (fromCharIdx > charCount) {
                    this.out.end = 0;
                    this.out.start = 0;
                } else {
                    this.out.start = StringFunctionUtil.getUTF8CharPosition(this.string.buffer, this.string.start, this.string.end, fromCharIdx - 1);
                    this.out.end = this.string.end;
                }
            }
        }
    }

    @FunctionTemplate(names={"substring", "substr"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class Substring
    implements DrillSimpleFunc {
        @Param
        VarCharHolder string;
        @Param
        BigIntHolder offset;
        @Param
        BigIntHolder length;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.buffer = this.string.buffer;
            if (this.length.value <= 0L || this.offset.value <= 0L || this.string.end <= this.string.start) {
                this.out.end = 0;
                this.out.start = 0;
            } else {
                int fromCharIdx = (int)this.offset.value;
                int charCount = StringFunctionUtil.getUTF8CharLength(this.string.buffer, this.string.start, this.string.end);
                if (fromCharIdx > charCount) {
                    this.out.end = 0;
                    this.out.start = 0;
                } else {
                    this.out.start = StringFunctionUtil.getUTF8CharPosition(this.string.buffer, this.string.start, this.string.end, fromCharIdx - 1);
                    int charLen = Math.min((int)this.length.value, charCount - fromCharIdx + 1);
                    this.out.end = StringFunctionUtil.getUTF8CharPosition(this.string.buffer, this.out.start, this.string.end, charLen);
                }
            }
        }
    }

    @FunctionTemplate(name="upper", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.SAME_IN_OUT_LENGTH, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CLONE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class UpperCase
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            String str = StringFunctionHelpers.toStringFromUTF8(this.input.start, this.input.end, this.input.buffer);
            byte[] result = str.toUpperCase().getBytes(Charsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.start = 0;
            this.out.end = result.length;
            this.out.buffer.setBytes(0, result);
        }
    }

    @FunctionTemplate(name="lower", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.SAME_IN_OUT_LENGTH, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CLONE)
    public static class LowerCase
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            String str = StringFunctionHelpers.toStringFromUTF8(this.input.start, this.input.end, this.input.buffer);
            byte[] result = str.toLowerCase().getBytes(Charsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.start = 0;
            this.out.end = result.length;
            this.out.buffer.setBytes(0, result);
        }
    }

    @FunctionTemplate(name="strpos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Strpos
    implements DrillSimpleFunc {
        @Param
        VarCharHolder str;
        @Param
        VarCharHolder substr;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int pos = StringFunctionUtil.stringLeftMatchUTF8(this.str.buffer, this.str.start, this.str.end, this.substr.buffer, this.substr.start, this.substr.end);
            this.out.value = pos < 0 ? 0L : (long)(StringFunctionUtil.getUTF8CharLength(this.str.buffer, this.str.start, pos) + 1);
        }
    }

    @FunctionTemplate(name="split_part", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_FIXED_WIDTH_DEFAULT)
    public static class SplitPartStartEnd
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Param
        VarCharHolder delimiter;
        @Param
        IntHolder start;
        @Param
        IntHolder end;
        @Workspace
        Splitter splitter;
        @Workspace
        Joiner joiner;
        @Inject
        DrillBuf buffer;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
            String split = StringFunctionHelpers.toStringFromUTF8(this.delimiter.start, this.delimiter.end, this.delimiter.buffer);
            this.splitter = Splitter.on(split);
            this.joiner = Joiner.on(split);
        }

        @Override
        public void eval() {
            if (this.start.value == 0) {
                throw UserException.functionError().message("Start index in split_part can not be zero, value provided was [start:" + this.start.value + "]", new Object[0]).build();
            }
            if (this.start.value * this.end.value <= 0) {
                throw UserException.functionError().message("End index in split_part must has the same sign as the start index, value provided was [start:" + this.start.value + ",end:" + this.end.value + "]", new Object[0]).build();
            }
            if (this.end.value < this.start.value) {
                throw UserException.functionError().message("End index in split_part must be greater or equal to start index, value provided was [start:" + this.start.value + ",end:" + this.end.value + "]", new Object[0]).build();
            }
            String inputString = StringFunctionHelpers.getStringFromVarCharHolder(this.in);
            Iterator<Object> iterator = Collections.emptyIterator();
            if (this.start.value < 0) {
                List<String> splits = this.splitter.splitToList(inputString);
                int size = splits.size();
                int startIndex = size + this.start.value;
                int endIndex = size + this.end.value + 1;
                if (startIndex >= 0) {
                    iterator = splits.subList(startIndex, endIndex).iterator();
                } else if (endIndex > 0) {
                    iterator = splits.subList(0, endIndex).iterator();
                }
            } else {
                int arrayIndex = this.start.value - 1;
                iterator = Iterables.limit(Iterables.skip(this.splitter.split(inputString), arrayIndex), this.end.value - this.start.value + 1).iterator();
            }
            byte[] strBytes = this.joiner.join(iterator).getBytes(Charsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(strBytes.length);
            this.out.start = 0;
            this.out.end = strBytes.length;
            this.out.buffer.setBytes(0, strBytes);
        }
    }

    @FunctionTemplate(name="split_part", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_FIXED_WIDTH_DEFAULT)
    public static class SplitPart
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Param
        VarCharHolder delimiter;
        @Param
        IntHolder index;
        @Workspace
        Splitter splitter;
        @Inject
        DrillBuf buffer;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
            String split = StringFunctionHelpers.toStringFromUTF8(this.delimiter.start, this.delimiter.end, this.delimiter.buffer);
            this.splitter = Splitter.on(split);
        }

        @Override
        public void eval() {
            if (this.index.value == 0) {
                throw UserException.functionError().message("Index in split_part can not be zero", new Object[0]).build();
            }
            String inputString = StringFunctionHelpers.getStringFromVarCharHolder(this.in);
            String result = "";
            if (this.index.value < 0) {
                List<String> splits = this.splitter.splitToList(inputString);
                int size = splits.size();
                int arrayIndex = size + this.index.value;
                if (arrayIndex >= 0) {
                    result = splits.get(arrayIndex);
                }
            } else {
                int arrayIndex = this.index.value - 1;
                result = Iterables.get(this.splitter.split(inputString), arrayIndex, "");
            }
            byte[] strBytes = result.getBytes(Charsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(strBytes.length);
            this.out.start = 0;
            this.out.end = strBytes.length;
            this.out.buffer.setBytes(0, strBytes);
        }
    }

    @FunctionTemplate(name="position", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Position
    implements DrillSimpleFunc {
        @Param
        VarCharHolder substr;
        @Param
        VarCharHolder str;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int pos = StringFunctionUtil.stringLeftMatchUTF8(this.str.buffer, this.str.start, this.str.end, this.substr.buffer, this.substr.start, this.substr.end);
            this.out.value = pos < 0 ? 0L : (long)(StringFunctionUtil.getUTF8CharLength(this.str.buffer, this.str.start, pos) + 1);
        }
    }

    @FunctionTemplate(name="bit_length", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class BitLength
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (long)(this.input.end - this.input.start) * 8L;
        }
    }

    @FunctionTemplate(name="octet_length", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class OctetLength
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input.end - this.input.start;
        }
    }

    @FunctionTemplate(name="lengthUtf8", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ByteLength
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder input;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = StringFunctionUtil.getUTF8CharLength(this.input.buffer, this.input.start, this.input.end);
        }
    }

    @FunctionTemplate(names={"char_length", "character_length", "length"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CharLength
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = StringFunctionUtil.getUTF8CharLength(this.input.buffer, this.input.start, this.input.end);
        }
    }

    @FunctionTemplate(name="regexp_matches", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RegexpMatches
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Param(constant=true)
        VarCharHolder pattern;
        @Workspace
        Matcher matcher;
        @Workspace
        CharSequenceWrapper charSequenceWrapper;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.matcher = Pattern.compile(StringFunctionHelpers.toStringFromUTF8(this.pattern.start, this.pattern.end, this.pattern.buffer)).matcher("");
            this.charSequenceWrapper = new CharSequenceWrapper();
            this.matcher.reset(this.charSequenceWrapper);
        }

        @Override
        public void eval() {
            this.charSequenceWrapper.setBuffer(this.input.start, this.input.end, this.input.buffer);
            this.matcher.reset();
            this.out.value = this.matcher.matches() ? 1 : 0;
        }
    }

    @FunctionTemplate(name="regexp_replace", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class RegexpReplace
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Param(constant=true)
        VarCharHolder pattern;
        @Param
        VarCharHolder replacement;
        @Inject
        DrillBuf buffer;
        @Workspace
        Matcher matcher;
        @Workspace
        CharSequenceWrapper charSequenceWrapper;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
            this.matcher = Pattern.compile(StringFunctionHelpers.toStringFromUTF8(this.pattern.start, this.pattern.end, this.pattern.buffer)).matcher("");
            this.charSequenceWrapper = new CharSequenceWrapper();
            this.matcher.reset(this.charSequenceWrapper);
        }

        @Override
        public void eval() {
            this.out.start = 0;
            this.charSequenceWrapper.setBuffer(this.input.start, this.input.end, this.input.buffer);
            String r = StringFunctionHelpers.toStringFromUTF8(this.replacement.start, this.replacement.end, this.replacement.buffer);
            this.matcher.reset();
            boolean result = this.matcher.find();
            if (result) {
                StringBuffer sb = new StringBuffer();
                do {
                    this.matcher.appendReplacement(sb, r);
                } while (result = this.matcher.find());
                this.matcher.appendTail(sb);
                byte[] bytea = sb.toString().getBytes(StandardCharsets.UTF_8);
                this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(bytea.length);
                this.out.buffer.setBytes(this.out.start, bytea);
                this.out.end = bytea.length;
            } else {
                this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(this.input.end - this.input.start);
                this.out.buffer.setBytes(0, this.input.buffer, this.input.start, this.input.end - this.input.start);
                this.out.end = this.input.end - this.input.start;
            }
        }
    }

    @FunctionTemplate(names={"similar", "similar_to"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SimilarWithEscape
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Param(constant=true)
        VarCharHolder pattern;
        @Param(constant=true)
        VarCharHolder escape;
        @Output
        BitHolder out;
        @Workspace
        Matcher matcher;
        @Workspace
        CharSequenceWrapper charSequenceWrapper;

        @Override
        public void setup() {
            this.matcher = Pattern.compile(RegexpUtil.sqlToRegexSimilar(StringFunctionHelpers.toStringFromUTF8(this.pattern.start, this.pattern.end, this.pattern.buffer), StringFunctionHelpers.toStringFromUTF8(this.escape.start, this.escape.end, this.escape.buffer))).matcher("");
            this.charSequenceWrapper = new CharSequenceWrapper();
            this.matcher.reset(this.charSequenceWrapper);
        }

        @Override
        public void eval() {
            this.charSequenceWrapper.setBuffer(this.input.start, this.input.end, this.input.buffer);
            this.matcher.reset();
            this.out.value = this.matcher.matches() ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"similar", "similar_to"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Similar
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Param(constant=true)
        VarCharHolder pattern;
        @Output
        BitHolder out;
        @Workspace
        Matcher matcher;
        @Workspace
        CharSequenceWrapper charSequenceWrapper;

        @Override
        public void setup() {
            this.matcher = Pattern.compile(RegexpUtil.sqlToRegexSimilar(StringFunctionHelpers.toStringFromUTF8(this.pattern.start, this.pattern.end, this.pattern.buffer))).matcher("");
            this.charSequenceWrapper = new CharSequenceWrapper();
            this.matcher.reset(this.charSequenceWrapper);
        }

        @Override
        public void eval() {
            this.charSequenceWrapper.setBuffer(this.input.start, this.input.end, this.input.buffer);
            this.matcher.reset();
            this.out.value = this.matcher.matches() ? 1 : 0;
        }
    }

    @FunctionTemplate(name="ilike", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ILikeWithEscape
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Param(constant=true)
        VarCharHolder pattern;
        @Param(constant=true)
        VarCharHolder escape;
        @Output
        BitHolder out;
        @Workspace
        Matcher matcher;
        @Workspace
        CharSequenceWrapper charSequenceWrapper;

        @Override
        public void setup() {
            this.matcher = Pattern.compile(RegexpUtil.sqlToRegexLike(StringFunctionHelpers.toStringFromUTF8(this.pattern.start, this.pattern.end, this.pattern.buffer), StringFunctionHelpers.toStringFromUTF8(this.escape.start, this.escape.end, this.escape.buffer)).getJavaPatternString(), 2).matcher("");
            this.charSequenceWrapper = new CharSequenceWrapper();
            this.matcher.reset(this.charSequenceWrapper);
        }

        @Override
        public void eval() {
            this.charSequenceWrapper.setBuffer(this.input.start, this.input.end, this.input.buffer);
            this.matcher.reset();
            this.out.value = this.matcher.matches() ? 1 : 0;
        }
    }

    @FunctionTemplate(name="ilike", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ILike
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Param(constant=true)
        VarCharHolder pattern;
        @Output
        BitHolder out;
        @Workspace
        Matcher matcher;
        @Workspace
        CharSequenceWrapper charSequenceWrapper;

        @Override
        public void setup() {
            this.matcher = Pattern.compile(RegexpUtil.sqlToRegexLike(StringFunctionHelpers.toStringFromUTF8(this.pattern.start, this.pattern.end, this.pattern.buffer)).getJavaPatternString(), 2).matcher("");
            this.charSequenceWrapper = new CharSequenceWrapper();
            this.matcher.reset(this.charSequenceWrapper);
        }

        @Override
        public void eval() {
            this.charSequenceWrapper.setBuffer(this.input.start, this.input.end, this.input.buffer);
            this.matcher.reset();
            this.out.value = this.matcher.matches() ? 1 : 0;
        }
    }

    @FunctionTemplate(name="like", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LikeWithEscape
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Param(constant=true)
        VarCharHolder pattern;
        @Param(constant=true)
        VarCharHolder escape;
        @Output
        BitHolder out;
        @Workspace
        RegexpUtil.SqlPatternInfo sqlPatternInfo;
        @Workspace
        SqlPatternMatcher sqlPatternMatcher;

        @Override
        public void setup() {
            this.sqlPatternInfo = RegexpUtil.sqlToRegexLike(StringFunctionHelpers.toStringFromUTF8(this.pattern.start, this.pattern.end, this.pattern.buffer), StringFunctionHelpers.toStringFromUTF8(this.escape.start, this.escape.end, this.escape.buffer));
            this.sqlPatternMatcher = SqlPatternFactory.getSqlPatternMatcher(this.sqlPatternInfo);
        }

        @Override
        public void eval() {
            this.out.value = this.sqlPatternMatcher.match(this.input.start, this.input.end, this.input.buffer);
        }
    }

    @FunctionTemplate(name="like", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Like
    implements DrillSimpleFunc {
        @Param
        VarCharHolder input;
        @Param(constant=true)
        VarCharHolder pattern;
        @Output
        BitHolder out;
        @Workspace
        RegexpUtil.SqlPatternInfo sqlPatternInfo;
        @Workspace
        SqlPatternMatcher sqlPatternMatcher;

        @Override
        public void setup() {
            this.sqlPatternInfo = RegexpUtil.sqlToRegexLike(StringFunctionHelpers.toStringFromUTF8(this.pattern.start, this.pattern.end, this.pattern.buffer));
            this.sqlPatternMatcher = SqlPatternFactory.getSqlPatternMatcher(this.sqlPatternInfo);
        }

        @Override
        public void eval() {
            this.out.value = this.sqlPatternMatcher.match(this.input.start, this.input.end, this.input.buffer);
        }
    }
}

