/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;

public class TimeIntervalDayFunctions {

    @FunctionTemplate(names={"date_sub", "subtract", "date_diff"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimeIntervalDaySubtractFunction
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        TimeHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.value - this.right.milliseconds;
            this.out.value %= 86400000;
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalDayTimeAddFunction
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder right;
        @Param
        TimeHolder left;
        @Output
        TimeHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.value + this.right.milliseconds;
            this.out.value %= 86400000;
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimeIntervalDayAddFunction
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        TimeHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.value + this.right.milliseconds;
            this.out.value %= 86400000;
        }
    }
}

