/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;

public class TimeStampIntervalFunctions {

    @FunctionTemplate(names={"date_sub", "subtract", "date_diff"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimeStampIntervalSubtractFunction
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        IntervalHolder right;
        @Workspace
        MutableDateTime temp;
        @Output
        TimeStampHolder out;

        @Override
        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addMonths(this.right.months * -1);
            this.temp.addDays(this.right.days * -1);
            this.temp.add((long)(this.right.milliseconds * -1));
            this.out.value = this.temp.getMillis();
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalTimeStampAddFunction
    implements DrillSimpleFunc {
        @Param
        IntervalHolder right;
        @Param
        TimeStampHolder left;
        @Workspace
        MutableDateTime temp;
        @Output
        TimeStampHolder out;

        @Override
        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addMonths(this.right.months);
            this.temp.addDays(this.right.days);
            this.temp.add((long)this.right.milliseconds);
            this.out.value = this.temp.getMillis();
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimeStampIntervalAddFunction
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        IntervalHolder right;
        @Workspace
        MutableDateTime temp;
        @Output
        TimeStampHolder out;

        @Override
        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addMonths(this.right.months);
            this.temp.addDays(this.right.days);
            this.temp.add((long)this.right.milliseconds);
            this.out.value = this.temp.getMillis();
        }
    }
}

