/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrigoMathFunctions {
    static final Logger logger = LoggerFactory.getLogger(TrigoMathFunctions.class);

    private TrigoMathFunctions() {
    }

    @FunctionTemplate(name="cot", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CotUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 1.0 / Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="cot", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CotUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 1.0 / Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="cot", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CotUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 1.0 / Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="cot", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CotUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 1.0 / Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="cot", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CotTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 1.0 / Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="cot", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CotSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 1.0 / Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="cot", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CotFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 1.0 / Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="cot", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CotFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 1.0 / Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="cot", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CotBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 1.0 / Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="cot", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CotInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 1.0 / Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="tanh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanhUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tanh(this.in.value);
        }
    }

    @FunctionTemplate(name="tanh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanhUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tanh(this.in.value);
        }
    }

    @FunctionTemplate(name="tanh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanhUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tanh(this.in.value);
        }
    }

    @FunctionTemplate(name="tanh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanhUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tanh(this.in.value);
        }
    }

    @FunctionTemplate(name="tanh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanhTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tanh(this.in.value);
        }
    }

    @FunctionTemplate(name="tanh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanhSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tanh(this.in.value);
        }
    }

    @FunctionTemplate(name="tanh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanhFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tanh(this.in.value);
        }
    }

    @FunctionTemplate(name="tanh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanhFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tanh(this.in.value);
        }
    }

    @FunctionTemplate(name="tanh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanhBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tanh(this.in.value);
        }
    }

    @FunctionTemplate(name="tanh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanhInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tanh(this.in.value);
        }
    }

    @FunctionTemplate(name="cosh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CoshUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cosh(this.in.value);
        }
    }

    @FunctionTemplate(name="cosh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CoshUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cosh(this.in.value);
        }
    }

    @FunctionTemplate(name="cosh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CoshUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cosh(this.in.value);
        }
    }

    @FunctionTemplate(name="cosh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CoshUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cosh(this.in.value);
        }
    }

    @FunctionTemplate(name="cosh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CoshTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cosh(this.in.value);
        }
    }

    @FunctionTemplate(name="cosh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CoshSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cosh(this.in.value);
        }
    }

    @FunctionTemplate(name="cosh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CoshFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cosh(this.in.value);
        }
    }

    @FunctionTemplate(name="cosh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CoshFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cosh(this.in.value);
        }
    }

    @FunctionTemplate(name="cosh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CoshBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cosh(this.in.value);
        }
    }

    @FunctionTemplate(name="cosh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CoshInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cosh(this.in.value);
        }
    }

    @FunctionTemplate(name="sinh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinhUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sinh(this.in.value);
        }
    }

    @FunctionTemplate(name="sinh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinhUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sinh(this.in.value);
        }
    }

    @FunctionTemplate(name="sinh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinhUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sinh(this.in.value);
        }
    }

    @FunctionTemplate(name="sinh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinhUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sinh(this.in.value);
        }
    }

    @FunctionTemplate(name="sinh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinhTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sinh(this.in.value);
        }
    }

    @FunctionTemplate(name="sinh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinhSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sinh(this.in.value);
        }
    }

    @FunctionTemplate(name="sinh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinhFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sinh(this.in.value);
        }
    }

    @FunctionTemplate(name="sinh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinhFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sinh(this.in.value);
        }
    }

    @FunctionTemplate(name="sinh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinhBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sinh(this.in.value);
        }
    }

    @FunctionTemplate(name="sinh", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinhInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sinh(this.in.value);
        }
    }

    @FunctionTemplate(name="atan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ATanUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.atan(this.in.value);
        }
    }

    @FunctionTemplate(name="atan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ATanUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.atan(this.in.value);
        }
    }

    @FunctionTemplate(name="atan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ATanUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.atan(this.in.value);
        }
    }

    @FunctionTemplate(name="atan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ATanUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.atan(this.in.value);
        }
    }

    @FunctionTemplate(name="atan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ATanTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.atan(this.in.value);
        }
    }

    @FunctionTemplate(name="atan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ATanSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.atan(this.in.value);
        }
    }

    @FunctionTemplate(name="atan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ATanFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.atan(this.in.value);
        }
    }

    @FunctionTemplate(name="atan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ATanFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.atan(this.in.value);
        }
    }

    @FunctionTemplate(name="atan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ATanBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.atan(this.in.value);
        }
    }

    @FunctionTemplate(name="atan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ATanInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.atan(this.in.value);
        }
    }

    @FunctionTemplate(name="acos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ACosUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.acos(this.in.value);
        }
    }

    @FunctionTemplate(name="acos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ACosUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.acos(this.in.value);
        }
    }

    @FunctionTemplate(name="acos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ACosUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.acos(this.in.value);
        }
    }

    @FunctionTemplate(name="acos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ACosUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.acos(this.in.value);
        }
    }

    @FunctionTemplate(name="acos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ACosTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.acos(this.in.value);
        }
    }

    @FunctionTemplate(name="acos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ACosSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.acos(this.in.value);
        }
    }

    @FunctionTemplate(name="acos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ACosFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.acos(this.in.value);
        }
    }

    @FunctionTemplate(name="acos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ACosFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.acos(this.in.value);
        }
    }

    @FunctionTemplate(name="acos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ACosBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.acos(this.in.value);
        }
    }

    @FunctionTemplate(name="acos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ACosInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.acos(this.in.value);
        }
    }

    @FunctionTemplate(name="asin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ASinUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.asin(this.in.value);
        }
    }

    @FunctionTemplate(name="asin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ASinUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.asin(this.in.value);
        }
    }

    @FunctionTemplate(name="asin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ASinUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.asin(this.in.value);
        }
    }

    @FunctionTemplate(name="asin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ASinUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.asin(this.in.value);
        }
    }

    @FunctionTemplate(name="asin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ASinTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.asin(this.in.value);
        }
    }

    @FunctionTemplate(name="asin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ASinSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.asin(this.in.value);
        }
    }

    @FunctionTemplate(name="asin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ASinFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.asin(this.in.value);
        }
    }

    @FunctionTemplate(name="asin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ASinFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.asin(this.in.value);
        }
    }

    @FunctionTemplate(name="asin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ASinBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.asin(this.in.value);
        }
    }

    @FunctionTemplate(name="asin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ASinInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.asin(this.in.value);
        }
    }

    @FunctionTemplate(name="tan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="tan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="tan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="tan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="tan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="tan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="tan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="tan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="tan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="tan", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TanInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.tan(this.in.value);
        }
    }

    @FunctionTemplate(name="cos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CosUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cos(this.in.value);
        }
    }

    @FunctionTemplate(name="cos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CosUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cos(this.in.value);
        }
    }

    @FunctionTemplate(name="cos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CosUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cos(this.in.value);
        }
    }

    @FunctionTemplate(name="cos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CosUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cos(this.in.value);
        }
    }

    @FunctionTemplate(name="cos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CosTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cos(this.in.value);
        }
    }

    @FunctionTemplate(name="cos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CosSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cos(this.in.value);
        }
    }

    @FunctionTemplate(name="cos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CosFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cos(this.in.value);
        }
    }

    @FunctionTemplate(name="cos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CosFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cos(this.in.value);
        }
    }

    @FunctionTemplate(name="cos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CosBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cos(this.in.value);
        }
    }

    @FunctionTemplate(name="cos", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CosInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.cos(this.in.value);
        }
    }

    @FunctionTemplate(name="sin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sin(this.in.value);
        }
    }

    @FunctionTemplate(name="sin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sin(this.in.value);
        }
    }

    @FunctionTemplate(name="sin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sin(this.in.value);
        }
    }

    @FunctionTemplate(name="sin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sin(this.in.value);
        }
    }

    @FunctionTemplate(name="sin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sin(this.in.value);
        }
    }

    @FunctionTemplate(name="sin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sin(this.in.value);
        }
    }

    @FunctionTemplate(name="sin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sin(this.in.value);
        }
    }

    @FunctionTemplate(name="sin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sin(this.in.value);
        }
    }

    @FunctionTemplate(name="sin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sin(this.in.value);
        }
    }

    @FunctionTemplate(name="sin", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SinInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sin(this.in.value);
        }
    }
}

