/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.UnionHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.resolver.TypeCastRules;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public class UnionFunctions {
    public static int compareTypes(TypeProtos.MinorType type1, TypeProtos.MinorType type2) {
        int typeValue1 = UnionFunctions.getTypeValue(type1);
        int typeValue2 = UnionFunctions.getTypeValue(type2);
        return typeValue1 - typeValue2;
    }

    private static int getTypeValue(TypeProtos.MinorType type) {
        if (TypeCastRules.isNumericType(type)) {
            return 0;
        }
        switch (type) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case UINT1: 
            case UINT2: 
            case UINT4: 
            case UINT8: 
            case DECIMAL9: 
            case DECIMAL18: 
            case DECIMAL28SPARSE: 
            case DECIMAL38SPARSE: 
            case VARDECIMAL: 
            case FLOAT4: 
            case FLOAT8: {
                return 0;
            }
            case VARCHAR: 
            case VAR16CHAR: {
                return 1;
            }
            case VARBINARY: {
                return 2;
            }
            case BIT: {
                return 3;
            }
            case DATE: {
                return 4;
            }
            case TIMESTAMP: {
                return 5;
            }
        }
        return 6 + type.getNumber();
    }

    @FunctionTemplate(names={"isnull", "is null"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class IsNull
    implements DrillSimpleFunc {
        @Param
        UnionHolder input;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input.isSet == 1 ? 0 : 1;
        }
    }

    @FunctionTemplate(names={"isnotnull", "is not null"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class IsNotNull
    implements DrillSimpleFunc {
        @Param
        UnionHolder input;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input.isSet == 1 ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"IS_MAP", "IS_STRUCT"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class UnionIsMap
    implements DrillSimpleFunc {
        @Param
        UnionHolder in;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 1 ? (this.in.getType().getMinorType() == TypeProtos.MinorType.MAP ? 1 : 0) : 0;
        }
    }

    @FunctionTemplate(name="ASSERT_MAP", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class CastUnionMap
    implements DrillSimpleFunc {
        @Param
        UnionHolder in;
        @Output
        UnionHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (this.in.isSet == 1) {
                if (this.in.reader.getType().getMinorType() != TypeProtos.MinorType.MAP) {
                    throw new UnsupportedOperationException("The input is not a MAP type");
                }
                this.out.reader = this.in.reader;
            } else {
                this.out.isSet = 0;
            }
        }
    }

    @FunctionTemplate(name="IS_LIST", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class UnionIsList
    implements DrillSimpleFunc {
        @Param
        UnionHolder in;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 1 ? (this.in.getType().getMinorType() == TypeProtos.MinorType.LIST ? 1 : 0) : 0;
        }
    }

    @FunctionTemplate(name="ASSERT_LIST", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class CastUnionList
    implements DrillSimpleFunc {
        @Param
        UnionHolder in;
        @Output
        UnionHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (this.in.isSet == 1) {
                if (this.in.reader.getType().getMinorType() != TypeProtos.MinorType.LIST) {
                    throw new UnsupportedOperationException("The input is not a LIST type");
                }
                this.out.reader = this.in.reader;
            } else {
                this.out.isSet = 0;
            }
        }
    }

    @FunctionTemplate(names={"castUNION", "castToUnion"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastUnionToUnion
    implements DrillSimpleFunc {
        @Param
        FieldReader in;
        @Output
        UnionHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.reader = this.in;
            this.out.isSet = this.in.isSet() ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"typeOf"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GetType
    implements DrillSimpleFunc {
        @Param
        FieldReader input;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            String typeName = this.input.getTypeString();
            byte[] type = typeName.getBytes(StandardCharsets.UTF_8);
            this.buf = this.buf.reallocIfNeeded(type.length);
            this.buf.setBytes(0, type);
            this.out.buffer = this.buf;
            this.out.start = 0;
            this.out.end = type.length;
        }
    }

    @FunctionTemplate(names={"compareType"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class CompareType
    implements DrillSimpleFunc {
        @Param
        FieldReader input1;
        @Param
        FieldReader input2;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            TypeProtos.MinorType type1 = this.input1.isSet() ? this.input1.getType().getMinorType() : TypeProtos.MinorType.NULL;
            TypeProtos.MinorType type2 = this.input2.isSet() ? this.input2.getType().getMinorType() : TypeProtos.MinorType.NULL;
            this.out.value = UnionFunctions.compareTypes(type1, type2);
        }
    }
}

