/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import java.io.IOException;
import javax.inject.Named;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.compile.TemplateClassDefinition;
import org.apache.drill.exec.compile.sig.GeneratorMapping;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.compile.sig.RuntimeOverridden;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.planner.physical.HashPrelUtil;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessible;

public class ValueVectorHashHelper {
    private RecordBatch recordBatch;
    private FragmentContext context;
    private TemplateClassDefinition<Hash64> TEMPLATE_DEFINITION = new TemplateClassDefinition<Hash64>(Hash64.class, Hash64Template.class);
    private static final GeneratorMapping DO_SETUP_CONSTANT = GeneratorMapping.create("doSetup", "doSetup", null, null);
    private static final GeneratorMapping GET_HASH_BUILD_INNER = GeneratorMapping.create("doSetup", "hash64Code", null, null);
    private final MappingSet GetHashIncomingBuildColMapping = new MappingSet("incomingRowIdx", null, "incoming", null, DO_SETUP_CONSTANT, GET_HASH_BUILD_INNER);

    public ValueVectorHashHelper(RecordBatch recordBatch, FragmentContext context) {
        this.recordBatch = recordBatch;
        this.context = context;
    }

    public Hash64 getHash64(LogicalExpression[] hashFieldsExp, TypedFieldId[] hashFieldIds) throws ClassTransformationException, IOException, SchemaChangeException {
        CodeGenerator<Hash64> codeGenerator = CodeGenerator.get(this.TEMPLATE_DEFINITION);
        codeGenerator.plainJavaCapable(true);
        codeGenerator.preferPlainJava(true);
        ClassGenerator<Hash64> cg = codeGenerator.getRoot();
        this.setupBuild64Hash(cg, this.GetHashIncomingBuildColMapping, this.recordBatch, hashFieldsExp, hashFieldIds);
        Hash64 hash64 = this.context.getImplementationClass(codeGenerator);
        hash64.doSetup(this.recordBatch);
        return hash64;
    }

    private void setupBuild64Hash(ClassGenerator<Hash64> cg, MappingSet incomingMapping, VectorAccessible batch, LogicalExpression[] keyExprs, TypedFieldId[] toHashKeyFieldIds) throws SchemaChangeException {
        cg.setMappingSet(incomingMapping);
        if (keyExprs == null || keyExprs.length == 0) {
            cg.getEvalBlock()._return(JExpr.lit((int)0));
        }
        String seedValue = "seedValue";
        String fieldId = "fieldId";
        LogicalExpression seed = ValueExpressions.getParameterExpression(seedValue, Types.required(TypeProtos.MinorType.INT));
        LogicalExpression fieldIdParamExpr = ValueExpressions.getParameterExpression(fieldId, Types.required(TypeProtos.MinorType.INT));
        ClassGenerator.HoldingContainer fieldIdParamHolder = cg.addExpr(fieldIdParamExpr);
        int i = 0;
        for (LogicalExpression expr : keyExprs) {
            TypedFieldId targetTypeFieldId = toHashKeyFieldIds[i];
            ValueExpressions.IntExpression targetBuildFieldIdExp = new ValueExpressions.IntExpression(targetTypeFieldId.getFieldIds()[0], ExpressionPosition.UNKNOWN);
            JFieldRef targetBuildSideFieldId = cg.addExpr(targetBuildFieldIdExp, ClassGenerator.BlkCreateMode.TRUE_IF_BOUND).getValue();
            JBlock ifBlock = cg.getEvalBlock()._if(fieldIdParamHolder.getValue().eq((JExpression)targetBuildSideFieldId))._then();
            cg.nestEvalBlock(ifBlock);
            LogicalExpression hashExpression = HashPrelUtil.getHash64Expression(expr, seed, true);
            LogicalExpression materializedExpr = ExpressionTreeMaterializer.materializeAndCheckErrors(hashExpression, batch, this.context.getFunctionRegistry());
            ClassGenerator.HoldingContainer hash = cg.addExpr(materializedExpr, ClassGenerator.BlkCreateMode.TRUE_IF_BOUND);
            ifBlock._return((JExpression)hash.getValue());
            cg.unNestEvalBlock();
            ++i;
        }
        cg.getEvalBlock()._return(JExpr.lit((int)0));
    }

    public static interface Hash64 {
        public void doSetup(RecordBatch var1) throws SchemaChangeException;

        public long hash64Code(int var1, int var2, int var3) throws SchemaChangeException;
    }

    public static abstract class Hash64Template
    implements Hash64 {
        @Override
        @RuntimeOverridden
        public abstract void doSetup(@Named(value="incoming") RecordBatch var1) throws SchemaChangeException;

        @Override
        @RuntimeOverridden
        public abstract long hash64Code(@Named(value="incomingRowIdx") int var1, @Named(value="seedValue") int var2, @Named(value="fieldId") int var3) throws SchemaChangeException;
    }
}

