/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VarHelpers {
    static final Logger logger = LoggerFactory.getLogger(VarHelpers.class);

    public static final int compare(VarBinaryHolder left, VarCharHolder right) {
        int l = left.start;
        for (int r = right.start; l < left.end && r < right.end; ++l, ++r) {
            byte rightByte;
            byte leftByte = left.buffer.getByte(l);
            if (leftByte == (rightByte = right.buffer.getByte(r))) continue;
            return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
        }
        l = left.end - left.start - (right.end - right.start);
        if (l > 0) {
            return 1;
        }
        if (l == 0) {
            return 0;
        }
        return -1;
    }

    public static final int compare(VarCharHolder left, VarCharHolder right) {
        int l = left.start;
        for (int r = right.start; l < left.end && r < right.end; ++l, ++r) {
            byte rightByte;
            byte leftByte = left.buffer.getByte(l);
            if (leftByte == (rightByte = right.buffer.getByte(r))) continue;
            return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
        }
        l = left.end - left.start - (right.end - right.start);
        if (l > 0) {
            return 1;
        }
        if (l == 0) {
            return 0;
        }
        return -1;
    }

    public static final int compare(NullableVarBinaryHolder left, NullableVarBinaryHolder right) {
        if (left.isSet == 0) {
            if (right.isSet == 0) {
                return 0;
            }
            return -1;
        }
        if (right.isSet == 0) {
            return 1;
        }
        int l = left.start;
        for (int r = right.start; l < left.end && r < right.end; ++l, ++r) {
            byte rightByte;
            byte leftByte = left.buffer.getByte(l);
            if (leftByte == (rightByte = right.buffer.getByte(r))) continue;
            return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
        }
        l = left.end - left.start - (right.end - right.start);
        if (l > 0) {
            return 1;
        }
        if (l == 0) {
            return 0;
        }
        return -1;
    }

    public static final int compare(NullableVarBinaryHolder left, NullableVarCharHolder right) {
        if (left.isSet == 0) {
            if (right.isSet == 0) {
                return 0;
            }
            return -1;
        }
        if (right.isSet == 0) {
            return 1;
        }
        int l = left.start;
        for (int r = right.start; l < left.end && r < right.end; ++l, ++r) {
            byte rightByte;
            byte leftByte = left.buffer.getByte(l);
            if (leftByte == (rightByte = right.buffer.getByte(r))) continue;
            return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
        }
        l = left.end - left.start - (right.end - right.start);
        if (l > 0) {
            return 1;
        }
        if (l == 0) {
            return 0;
        }
        return -1;
    }

    public static final int compare(NullableVarCharHolder left, NullableVarCharHolder right) {
        if (left.isSet == 0) {
            if (right.isSet == 0) {
                return 0;
            }
            return -1;
        }
        if (right.isSet == 0) {
            return 1;
        }
        int l = left.start;
        for (int r = right.start; l < left.end && r < right.end; ++l, ++r) {
            byte rightByte;
            byte leftByte = left.buffer.getByte(l);
            if (leftByte == (rightByte = right.buffer.getByte(r))) continue;
            return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
        }
        l = left.end - left.start - (right.end - right.start);
        if (l > 0) {
            return 1;
        }
        if (l == 0) {
            return 0;
        }
        return -1;
    }

    public static final int compare(VarBinaryHolder left, VarBinaryHolder right) {
        int l = left.start;
        for (int r = right.start; l < left.end && r < right.end; ++l, ++r) {
            byte rightByte;
            byte leftByte = left.buffer.getByte(l);
            if (leftByte == (rightByte = right.buffer.getByte(r))) continue;
            return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
        }
        l = left.end - left.start - (right.end - right.start);
        if (l > 0) {
            return 1;
        }
        if (l == 0) {
            return 0;
        }
        return -1;
    }
}

