/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.conv;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;

@FunctionTemplate(name="convert_toBIGINT", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputSizeEstimate=8)
public class BigIntConvertTo
implements DrillSimpleFunc {
    @Param
    BigIntHolder in;
    @Output
    VarBinaryHolder out;
    @Inject
    DrillBuf buffer;

    @Override
    public void setup() {
        this.buffer = this.buffer.reallocIfNeeded(8);
    }

    @Override
    public void eval() {
        this.buffer.clear();
        this.buffer.writeLong(this.in.value);
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.end = 8;
    }
}

