/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.conv;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.util.ByteBufUtil;
import org.joda.time.DateTimeZone;

public class ConvertFromImpalaTimestamp {

    @FunctionTemplate(name="convert_fromTIMESTAMP_IMPALA", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ImpalaTimestampConvertFrom
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder in;
        @Output
        TimeStampHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            ByteBufUtil.checkBufferLength(this.in.buffer, this.in.start, this.in.end, 12);
            this.in.buffer.readerIndex(this.in.start);
            long nanosOfDay = this.in.buffer.readLong();
            int julianDay = this.in.buffer.readInt();
            long dateTime = ((long)julianDay - 2440588L) * 86400000L + nanosOfDay / 1000000L;
            this.out.value = DateTimeZone.getDefault().convertUTCToLocal(dateTime);
        }
    }
}

