/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.conv;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;

@FunctionTemplate(name="convert_toFLOAT", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputSizeEstimate=4)
public class FloatConvertTo
implements DrillSimpleFunc {
    @Param
    Float4Holder in;
    @Output
    VarBinaryHolder out;
    @Inject
    DrillBuf buffer;

    @Override
    public void setup() {
        this.buffer = this.buffer.reallocIfNeeded(4);
    }

    @Override
    public void eval() {
        this.buffer.clear();
        this.buffer.writeFloat(this.in.value);
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.end = 4;
    }
}

