/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvgFunctions {
    static final Logger logger = LoggerFactory.getLogger(AvgFunctions.class);

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat8Avg
    implements DrillAggFunc {
        @Param
        NullableFloat8Holder in;
        @Workspace
        Float8Holder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.sum = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0.0;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.sum.value += this.in.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.sum.value / (double)this.count.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0.0;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat4Avg
    implements DrillAggFunc {
        @Param
        NullableFloat4Holder in;
        @Workspace
        Float8Holder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.sum = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0.0;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.sum.value += (double)this.in.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.sum.value / (double)this.count.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0.0;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float8Avg
    implements DrillAggFunc {
        @Param
        Float8Holder in;
        @Workspace
        Float8Holder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.sum = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0.0;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.sum.value += this.in.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.sum.value / (double)this.count.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0.0;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float4Avg
    implements DrillAggFunc {
        @Param
        Float4Holder in;
        @Workspace
        Float8Holder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.sum = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0.0;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.sum.value += (double)this.in.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = this.sum.value / (double)this.count.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0.0;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBigIntAvg
    implements DrillAggFunc {
        @Param
        NullableBigIntHolder in;
        @Workspace
        BigIntHolder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.sum = new BigIntHolder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.sum.value += this.in.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = (double)this.sum.value / (double)this.count.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntAvg
    implements DrillAggFunc {
        @Param
        NullableIntHolder in;
        @Workspace
        BigIntHolder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.sum = new BigIntHolder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.sum.value += (long)this.in.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = (double)this.sum.value / (double)this.count.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BigIntAvg
    implements DrillAggFunc {
        @Param
        BigIntHolder in;
        @Workspace
        BigIntHolder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.sum = new BigIntHolder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.sum.value += this.in.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = (double)this.sum.value / (double)this.count.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }
    }

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntAvg
    implements DrillAggFunc {
        @Param
        IntHolder in;
        @Workspace
        BigIntHolder sum;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        @Override
        public void setup() {
            this.sum = new BigIntHolder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            this.sum.value += (long)this.in.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.value = (double)this.sum.value / (double)this.count.value;
                this.out.isSet = 1;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.nonNullCount.value = 0L;
            this.sum.value = 0L;
            this.count.value = 0L;
        }
    }
}

