/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrelationFunctions {
    static final Logger logger = LoggerFactory.getLogger(CorrelationFunctions.class);

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat8Correlation
    implements DrillAggFunc {
        @Param
        NullableFloat8Holder xIn;
        @Param
        NullableFloat8Holder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            if (this.xIn.isSet != 0 && this.yIn.isSet != 0) {
                double xOldMean = this.xMean.value;
                double yOldMean = this.yMean.value;
                this.xMean.value += (this.xIn.value - this.xMean.value) / (double)this.count.value;
                this.yMean.value += (this.yIn.value - this.yMean.value) / (double)this.count.value;
                this.xDev.value += (this.xIn.value - xOldMean) * (this.xIn.value - this.xMean.value);
                this.yDev.value += (this.yIn.value - yOldMean) * (this.yIn.value - this.yMean.value);
                this.xyMean.value += (this.xIn.value * this.yIn.value - this.xyMean.value) / (double)this.count.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float8Correlation
    implements DrillAggFunc {
        @Param
        Float8Holder xIn;
        @Param
        Float8Holder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            double xOldMean = this.xMean.value;
            double yOldMean = this.yMean.value;
            this.xMean.value += (this.xIn.value - this.xMean.value) / (double)this.count.value;
            this.yMean.value += (this.yIn.value - this.yMean.value) / (double)this.count.value;
            this.xDev.value += (this.xIn.value - xOldMean) * (this.xIn.value - this.xMean.value);
            this.yDev.value += (this.yIn.value - yOldMean) * (this.yIn.value - this.yMean.value);
            this.xyMean.value += (this.xIn.value * this.yIn.value - this.xyMean.value) / (double)this.count.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat4Correlation
    implements DrillAggFunc {
        @Param
        NullableFloat4Holder xIn;
        @Param
        NullableFloat4Holder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            if (this.xIn.isSet != 0 && this.yIn.isSet != 0) {
                double xOldMean = this.xMean.value;
                double yOldMean = this.yMean.value;
                this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
                this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
                this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
                this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
                this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float4Correlation
    implements DrillAggFunc {
        @Param
        Float4Holder xIn;
        @Param
        Float4Holder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            double xOldMean = this.xMean.value;
            double yOldMean = this.yMean.value;
            this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
            this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
            this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
            this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
            this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableUInt8Correlation
    implements DrillAggFunc {
        @Param
        NullableUInt8Holder xIn;
        @Param
        NullableUInt8Holder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            if (this.xIn.isSet != 0 && this.yIn.isSet != 0) {
                double xOldMean = this.xMean.value;
                double yOldMean = this.yMean.value;
                this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
                this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
                this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
                this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
                this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class UInt8Correlation
    implements DrillAggFunc {
        @Param
        UInt8Holder xIn;
        @Param
        UInt8Holder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            double xOldMean = this.xMean.value;
            double yOldMean = this.yMean.value;
            this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
            this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
            this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
            this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
            this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableUInt4Correlation
    implements DrillAggFunc {
        @Param
        NullableUInt4Holder xIn;
        @Param
        NullableUInt4Holder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            if (this.xIn.isSet != 0 && this.yIn.isSet != 0) {
                double xOldMean = this.xMean.value;
                double yOldMean = this.yMean.value;
                this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
                this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
                this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
                this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
                this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class UInt4Correlation
    implements DrillAggFunc {
        @Param
        UInt4Holder xIn;
        @Param
        UInt4Holder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            double xOldMean = this.xMean.value;
            double yOldMean = this.yMean.value;
            this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
            this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
            this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
            this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
            this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableUInt2Correlation
    implements DrillAggFunc {
        @Param
        NullableUInt2Holder xIn;
        @Param
        NullableUInt2Holder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            if (this.xIn.isSet != 0 && this.yIn.isSet != 0) {
                double xOldMean = this.xMean.value;
                double yOldMean = this.yMean.value;
                this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
                this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
                this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
                this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
                this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class UInt2Correlation
    implements DrillAggFunc {
        @Param
        UInt2Holder xIn;
        @Param
        UInt2Holder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            double xOldMean = this.xMean.value;
            double yOldMean = this.yMean.value;
            this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
            this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
            this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
            this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
            this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableUInt1Correlation
    implements DrillAggFunc {
        @Param
        NullableUInt1Holder xIn;
        @Param
        NullableUInt1Holder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            if (this.xIn.isSet != 0 && this.yIn.isSet != 0) {
                double xOldMean = this.xMean.value;
                double yOldMean = this.yMean.value;
                this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
                this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
                this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
                this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
                this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class UInt1Correlation
    implements DrillAggFunc {
        @Param
        UInt1Holder xIn;
        @Param
        UInt1Holder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            double xOldMean = this.xMean.value;
            double yOldMean = this.yMean.value;
            this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
            this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
            this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
            this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
            this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTinyIntCorrelation
    implements DrillAggFunc {
        @Param
        NullableTinyIntHolder xIn;
        @Param
        NullableTinyIntHolder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            if (this.xIn.isSet != 0 && this.yIn.isSet != 0) {
                double xOldMean = this.xMean.value;
                double yOldMean = this.yMean.value;
                this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
                this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
                this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
                this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
                this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TinyIntCorrelation
    implements DrillAggFunc {
        @Param
        TinyIntHolder xIn;
        @Param
        TinyIntHolder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            double xOldMean = this.xMean.value;
            double yOldMean = this.yMean.value;
            this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
            this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
            this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
            this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
            this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableSmallIntCorrelation
    implements DrillAggFunc {
        @Param
        NullableSmallIntHolder xIn;
        @Param
        NullableSmallIntHolder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            if (this.xIn.isSet != 0 && this.yIn.isSet != 0) {
                double xOldMean = this.xMean.value;
                double yOldMean = this.yMean.value;
                this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
                this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
                this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
                this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
                this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class SmallIntCorrelation
    implements DrillAggFunc {
        @Param
        SmallIntHolder xIn;
        @Param
        SmallIntHolder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            double xOldMean = this.xMean.value;
            double yOldMean = this.yMean.value;
            this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
            this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
            this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
            this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
            this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntCorrelation
    implements DrillAggFunc {
        @Param
        NullableIntHolder xIn;
        @Param
        NullableIntHolder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            if (this.xIn.isSet != 0 && this.yIn.isSet != 0) {
                double xOldMean = this.xMean.value;
                double yOldMean = this.yMean.value;
                this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
                this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
                this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
                this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
                this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntCorrelation
    implements DrillAggFunc {
        @Param
        IntHolder xIn;
        @Param
        IntHolder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            double xOldMean = this.xMean.value;
            double yOldMean = this.yMean.value;
            this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
            this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
            this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
            this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
            this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBigIntCorrelation
    implements DrillAggFunc {
        @Param
        NullableBigIntHolder xIn;
        @Param
        NullableBigIntHolder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            if (this.xIn.isSet != 0 && this.yIn.isSet != 0) {
                double xOldMean = this.xMean.value;
                double yOldMean = this.yMean.value;
                this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
                this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
                this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
                this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
                this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }

    @FunctionTemplate(names={"corr", "correlation"}, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BigIntCorrelation
    implements DrillAggFunc {
        @Param
        BigIntHolder xIn;
        @Param
        BigIntHolder yIn;
        @Workspace
        Float8Holder xMean;
        @Workspace
        Float8Holder yMean;
        @Workspace
        Float8Holder xyMean;
        @Workspace
        Float8Holder xDev;
        @Workspace
        Float8Holder yDev;
        @Workspace
        Float8Holder covar;
        @Workspace
        BigIntHolder count;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
            this.xMean = new Float8Holder();
            this.yMean = new Float8Holder();
            this.xyMean = new Float8Holder();
            this.xDev = new Float8Holder();
            this.yDev = new Float8Holder();
            this.count = new BigIntHolder();
            this.covar = new Float8Holder();
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.xDev.value = 0.0;
            this.yDev.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }

        @Override
        public void add() {
            double xOldMean = this.xMean.value;
            double yOldMean = this.yMean.value;
            this.xMean.value += ((double)this.xIn.value - this.xMean.value) / (double)this.count.value;
            this.yMean.value += ((double)this.yIn.value - this.yMean.value) / (double)this.count.value;
            this.xDev.value += ((double)this.xIn.value - xOldMean) * ((double)this.xIn.value - this.xMean.value);
            this.yDev.value += ((double)this.yIn.value - yOldMean) * ((double)this.yIn.value - this.yMean.value);
            this.xyMean.value += ((double)(this.xIn.value * this.yIn.value) - this.xyMean.value) / (double)this.count.value;
            ++this.count.value;
        }

        @Override
        public void output() {
            double xVariance = this.xDev.value / (double)(this.count.value - 1L);
            double yVariance = this.yDev.value / (double)(this.count.value - 1L);
            double xyCovariance = this.xyMean.value - this.xMean.value * this.yMean.value;
            this.out.value = xyCovariance / Math.sqrt(xVariance * yVariance);
        }

        @Override
        public void reset() {
            this.xMean.value = 0.0;
            this.yMean.value = 0.0;
            this.xyMean.value = 0.0;
            this.count.value = 1L;
            this.covar.value = 0.0;
        }
    }
}

