/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import org.apache.drill.exec.util.DecimalUtility;

public class DecimalAvgFunctions {

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, returnType=FunctionTemplate.ReturnType.DECIMAL_AVG_AGGREGATE)
    public static class NullableVarDecimalAvg
    implements DrillAggFunc {
        @Param
        NullableVarDecimalHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        BigIntHolder count;
        @Workspace
        IntHolder outputScale;
        @Output
        NullableVarDecimalHolder out;

        @Override
        public void setup() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.count = new BigIntHolder();
            this.count.value = 0L;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                ++this.count.value;
                BigDecimal currentValue = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale);
                this.value.obj = ((BigDecimal)this.value.obj).add(currentValue);
                if (this.outputScale.value == Integer.MIN_VALUE) {
                    this.outputScale.value = this.in.scale;
                }
            }
        }

        @Override
        public void output() {
            if (this.count.value > 0L) {
                this.out.isSet = 1;
                this.out.start = 0;
                this.out.scale = Math.max(this.outputScale.value, 6);
                BigDecimal average = ((BigDecimal)this.value.obj).divide(BigDecimal.valueOf(this.count.value), this.out.scale, 4);
                this.out.precision = DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
                byte[] bytes = average.unscaledValue().toByteArray();
                int len = bytes.length;
                this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
                this.out.buffer.setBytes(0, bytes);
                this.out.end = len;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.count = new BigIntHolder();
            this.count.value = 0L;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="avg", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, returnType=FunctionTemplate.ReturnType.DECIMAL_AVG_AGGREGATE)
    public static class VarDecimalAvg
    implements DrillAggFunc {
        @Param
        VarDecimalHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        BigIntHolder count;
        @Workspace
        IntHolder outputScale;
        @Output
        NullableVarDecimalHolder out;

        @Override
        public void setup() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.count = new BigIntHolder();
            this.count.value = 0L;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }

        @Override
        public void add() {
            ++this.count.value;
            BigDecimal currentValue = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale);
            this.value.obj = ((BigDecimal)this.value.obj).add(currentValue);
            if (this.outputScale.value == Integer.MIN_VALUE) {
                this.outputScale.value = this.in.scale;
            }
        }

        @Override
        public void output() {
            if (this.count.value > 0L) {
                this.out.isSet = 1;
                this.out.start = 0;
                this.out.scale = Math.max(this.outputScale.value, 6);
                BigDecimal average = ((BigDecimal)this.value.obj).divide(BigDecimal.valueOf(this.count.value), this.out.scale, 4);
                this.out.precision = DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
                byte[] bytes = average.unscaledValue().toByteArray();
                int len = bytes.length;
                this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
                this.out.buffer.setBytes(0, bytes);
                this.out.end = len;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.count = new BigIntHolder();
            this.count.value = 0L;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }
    }
}

