/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.DrillByteArray;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.util.DecimalUtility;

public class DecimalMaxFunctions {

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, returnType=FunctionTemplate.ReturnType.DECIMAL_AGGREGATE)
    public static class NullableVarDecimalMax
    implements DrillAggFunc {
        @Param
        NullableVarDecimalHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder scale;
        @Workspace
        IntHolder precision;
        @Workspace
        ObjectHolder tempResult;
        @Output
        NullableVarDecimalHolder out;
        @Workspace
        BigIntHolder nonNullCount;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
            this.tempResult = new ObjectHolder();
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                DrillByteArray tmp = (DrillByteArray)this.tempResult.obj;
                int cmp = 0;
                if (tmp != null) {
                    cmp = DecimalUtility.compareVarLenBytes(this.in.buffer, this.in.start, this.in.end, this.in.scale, tmp.getBytes(), this.scale.value, false);
                } else {
                    cmp = 1;
                    tmp = new DrillByteArray();
                    this.tempResult.obj = tmp;
                }
                if (cmp > 0) {
                    int inputLength = this.in.end - this.in.start;
                    if (tmp.getLength() >= inputLength) {
                        this.in.buffer.getBytes(this.in.start, tmp.getBytes(), 0, inputLength);
                        tmp.setLength(inputLength);
                    } else {
                        byte[] tempArray = new byte[this.in.end - this.in.start];
                        this.in.buffer.getBytes(this.in.start, tempArray, 0, this.in.end - this.in.start);
                        tmp.setBytes(tempArray);
                    }
                    this.scale.value = this.in.scale;
                    this.precision.value = this.in.precision;
                }
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                DrillByteArray tmp = (DrillByteArray)this.tempResult.obj;
                this.buf = this.buf.reallocIfNeeded(tmp.getLength());
                this.buf.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
                this.out.start = 0;
                this.out.end = tmp.getLength();
                this.out.buffer = this.buf;
                this.out.scale = this.scale.value;
                this.out.precision = this.precision.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.scale.value = 0;
            this.precision.value = 0;
            this.tempResult.obj = null;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, returnType=FunctionTemplate.ReturnType.DECIMAL_AGGREGATE)
    public static class VarDecimalMax
    implements DrillAggFunc {
        @Param
        VarDecimalHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder scale;
        @Workspace
        IntHolder precision;
        @Workspace
        ObjectHolder tempResult;
        @Output
        NullableVarDecimalHolder out;
        @Workspace
        BigIntHolder nonNullCount;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
            this.tempResult = new ObjectHolder();
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            DrillByteArray tmp = (DrillByteArray)this.tempResult.obj;
            int cmp = 0;
            if (tmp != null) {
                cmp = DecimalUtility.compareVarLenBytes(this.in.buffer, this.in.start, this.in.end, this.in.scale, tmp.getBytes(), this.scale.value, false);
            } else {
                cmp = 1;
                tmp = new DrillByteArray();
                this.tempResult.obj = tmp;
            }
            if (cmp > 0) {
                int inputLength = this.in.end - this.in.start;
                if (tmp.getLength() >= inputLength) {
                    this.in.buffer.getBytes(this.in.start, tmp.getBytes(), 0, inputLength);
                    tmp.setLength(inputLength);
                } else {
                    byte[] tempArray = new byte[this.in.end - this.in.start];
                    this.in.buffer.getBytes(this.in.start, tempArray, 0, this.in.end - this.in.start);
                    tmp.setBytes(tempArray);
                }
                this.scale.value = this.in.scale;
                this.precision.value = this.in.precision;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                DrillByteArray tmp = (DrillByteArray)this.tempResult.obj;
                this.buf = this.buf.reallocIfNeeded(tmp.getLength());
                this.buf.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
                this.out.start = 0;
                this.out.end = tmp.getLength();
                this.out.buffer = this.buf;
                this.out.scale = this.scale.value;
                this.out.precision = this.precision.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.scale.value = 0;
            this.precision.value = 0;
            this.tempResult.obj = null;
            this.nonNullCount.value = 0L;
        }
    }
}

