/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import javax.inject.Inject;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.util.DecimalUtility;

public class DecimalSingleValueFunctions {

    @FunctionTemplate(name="single_value", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, returnType=FunctionTemplate.ReturnType.DECIMAL_AGGREGATE)
    public static class NullableVarDecimalSingleValue
    implements DrillAggFunc {
        @Param
        NullableVarDecimalHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        IntHolder scale;
        @Workspace
        IntHolder precision;
        @Output
        NullableVarDecimalHolder out;
        @Workspace
        BigIntHolder nonNullCount;

        @Override
        public void setup() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                if (this.nonNullCount.value != 0L) {
                    throw UserException.functionError().message("Input for single_value function has more than one row", new Object[0]).build();
                }
                this.value.obj = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale);
                this.scale.value = this.in.scale;
                this.precision.value = this.in.precision;
                this.nonNullCount.value = 1L;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                byte[] bytes = ((BigDecimal)this.value.obj).unscaledValue().toByteArray();
                int len = bytes.length;
                this.out.start = 0;
                this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
                this.out.buffer.setBytes(0, bytes);
                this.out.end = len;
                this.out.scale = this.scale.value;
                this.out.precision = this.precision.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.scale.value = 0;
            this.precision.value = 0;
            this.value.obj = null;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="single_value", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, returnType=FunctionTemplate.ReturnType.DECIMAL_AGGREGATE)
    public static class VarDecimalSingleValue
    implements DrillAggFunc {
        @Param
        VarDecimalHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        IntHolder scale;
        @Workspace
        IntHolder precision;
        @Output
        NullableVarDecimalHolder out;
        @Workspace
        BigIntHolder nonNullCount;

        @Override
        public void setup() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            if (this.nonNullCount.value != 0L) {
                throw UserException.functionError().message("Input for single_value function has more than one row", new Object[0]).build();
            }
            this.value.obj = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale);
            this.scale.value = this.in.scale;
            this.precision.value = this.in.precision;
            this.nonNullCount.value = 1L;
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                byte[] bytes = ((BigDecimal)this.value.obj).unscaledValue().toByteArray();
                int len = bytes.length;
                this.out.start = 0;
                this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
                this.out.buffer.setBytes(0, bytes);
                this.out.end = len;
                this.out.scale = this.scale.value;
                this.out.precision = this.precision.value;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.scale.value = 0;
            this.precision.value = 0;
            this.value.obj = null;
            this.nonNullCount.value = 0L;
        }
    }
}

