/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import org.apache.drill.exec.util.DecimalUtility;

public class DecimalVariancePopFunctions {

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, returnType=FunctionTemplate.ReturnType.DECIMAL_AVG_AGGREGATE)
    public static class NullableVarDecimalVariancePop
    implements DrillAggFunc {
        @Param
        NullableVarDecimalHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder avg;
        @Workspace
        ObjectHolder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        IntHolder scale;
        @Output
        NullableVarDecimalHolder out;
        @Workspace
        BigIntHolder nonNullCount;

        @Override
        public void setup() {
            this.avg = new ObjectHolder();
            this.dev = new ObjectHolder();
            this.count = new BigIntHolder();
            this.scale = new IntHolder();
            this.scale.value = Integer.MIN_VALUE;
            this.avg.obj = BigDecimal.ZERO;
            this.dev.obj = BigDecimal.ZERO;
            this.count.value = 1L;
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                if (this.scale.value == Integer.MIN_VALUE) {
                    this.scale.value = Math.max(this.in.scale, 6);
                }
                BigDecimal temp = (BigDecimal)this.avg.obj;
                BigDecimal input = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale);
                this.avg.obj = ((BigDecimal)this.avg.obj).add(input.subtract(temp).divide(BigDecimal.valueOf(this.count.value), new MathContext(DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision(), RoundingMode.HALF_UP)));
                this.dev.obj = ((BigDecimal)this.dev.obj).add(input.subtract(temp).multiply(input.subtract((BigDecimal)this.avg.obj)));
                ++this.count.value;
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    BigDecimal result = ((BigDecimal)this.dev.obj).setScale(this.scale.value, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(this.count.value - 1L), RoundingMode.HALF_UP);
                    this.out.scale = this.scale.value;
                    result = result.setScale(this.out.scale, RoundingMode.HALF_UP);
                    this.out.start = 0;
                    this.out.precision = DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
                    DecimalUtility.checkValueOverflow(result, this.out.precision, this.out.scale);
                    byte[] bytes = result.unscaledValue().toByteArray();
                    int len = bytes.length;
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
                    this.out.buffer.setBytes(0, bytes);
                    this.out.end = len;
                } else {
                    this.out.start = 0;
                    this.out.end = 0;
                    this.out.buffer = this.buffer;
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.avg.obj = BigDecimal.ZERO;
            this.dev.obj = BigDecimal.ZERO;
            this.count.value = 1L;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, returnType=FunctionTemplate.ReturnType.DECIMAL_AVG_AGGREGATE)
    public static class VarDecimalVariancePop
    implements DrillAggFunc {
        @Param
        VarDecimalHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder avg;
        @Workspace
        ObjectHolder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        IntHolder scale;
        @Output
        NullableVarDecimalHolder out;
        @Workspace
        BigIntHolder nonNullCount;

        @Override
        public void setup() {
            this.avg = new ObjectHolder();
            this.dev = new ObjectHolder();
            this.count = new BigIntHolder();
            this.scale = new IntHolder();
            this.scale.value = Integer.MIN_VALUE;
            this.avg.obj = BigDecimal.ZERO;
            this.dev.obj = BigDecimal.ZERO;
            this.count.value = 1L;
            this.nonNullCount = new BigIntHolder();
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            if (this.scale.value == Integer.MIN_VALUE) {
                this.scale.value = Math.max(this.in.scale, 6);
            }
            BigDecimal temp = (BigDecimal)this.avg.obj;
            BigDecimal input = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale);
            this.avg.obj = ((BigDecimal)this.avg.obj).add(input.subtract(temp).divide(BigDecimal.valueOf(this.count.value), new MathContext(DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision(), RoundingMode.HALF_UP)));
            this.dev.obj = ((BigDecimal)this.dev.obj).add(input.subtract(temp).multiply(input.subtract((BigDecimal)this.avg.obj)));
            ++this.count.value;
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    BigDecimal result = ((BigDecimal)this.dev.obj).setScale(this.scale.value, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(this.count.value - 1L), RoundingMode.HALF_UP);
                    this.out.scale = this.scale.value;
                    result = result.setScale(this.out.scale, RoundingMode.HALF_UP);
                    this.out.start = 0;
                    this.out.precision = DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
                    DecimalUtility.checkValueOverflow(result, this.out.precision, this.out.scale);
                    byte[] bytes = result.unscaledValue().toByteArray();
                    int len = bytes.length;
                    this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(len);
                    this.out.buffer.setBytes(0, bytes);
                    this.out.end = len;
                } else {
                    this.out.start = 0;
                    this.out.end = 0;
                    this.out.buffer = this.buffer;
                }
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.avg.obj = BigDecimal.ZERO;
            this.dev.obj = BigDecimal.ZERO;
            this.count.value = 1L;
            this.nonNullCount.value = 0L;
        }
    }
}

