/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.fn.impl.DrillByteArray;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

public class MinVarBytesFunctions {

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarBinaryMin
    implements DrillAggFunc {
        @Param
        NullableVarBinaryHolder in;
        @Workspace
        ObjectHolder value;
        @Workspace
        UInt1Holder init;
        @Workspace
        BigIntHolder nonNullCount;
        @Inject
        DrillBuf buf;
        @Output
        NullableVarBinaryHolder out;

        @Override
        public void setup() {
            this.init = new UInt1Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.init.value = 0;
            this.value = new ObjectHolder();
            DrillByteArray tmp = new DrillByteArray();
            this.value.obj = tmp;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                DrillByteArray tmp = (DrillByteArray)this.value.obj;
                int cmp = 0;
                boolean swap = false;
                if (this.init.value == 0) {
                    this.init.value = 1;
                    swap = true;
                } else {
                    cmp = ByteFunctionHelpers.compare(this.in.buffer, this.in.start, this.in.end, tmp.getBytes(), 0, tmp.getLength());
                    boolean bl = swap = cmp == -1;
                }
                if (swap) {
                    int inputLength = this.in.end - this.in.start;
                    if (tmp.getLength() >= inputLength) {
                        this.in.buffer.getBytes(this.in.start, tmp.getBytes(), 0, inputLength);
                        tmp.setLength(inputLength);
                    } else {
                        byte[] tempArray = new byte[this.in.end - this.in.start];
                        this.in.buffer.getBytes(this.in.start, tempArray, 0, this.in.end - this.in.start);
                        tmp.setBytes(tempArray);
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                DrillByteArray tmp = (DrillByteArray)this.value.obj;
                this.buf = this.buf.reallocIfNeeded(tmp.getLength());
                this.buf.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
                this.out.start = 0;
                this.out.end = tmp.getLength();
                this.out.buffer = this.buf;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = new DrillByteArray();
            this.init.value = 0;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarBinaryMin
    implements DrillAggFunc {
        @Param
        VarBinaryHolder in;
        @Workspace
        ObjectHolder value;
        @Workspace
        UInt1Holder init;
        @Workspace
        BigIntHolder nonNullCount;
        @Inject
        DrillBuf buf;
        @Output
        NullableVarBinaryHolder out;

        @Override
        public void setup() {
            this.init = new UInt1Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.init.value = 0;
            this.value = new ObjectHolder();
            DrillByteArray tmp = new DrillByteArray();
            this.value.obj = tmp;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            DrillByteArray tmp = (DrillByteArray)this.value.obj;
            int cmp = 0;
            boolean swap = false;
            if (this.init.value == 0) {
                this.init.value = 1;
                swap = true;
            } else {
                cmp = ByteFunctionHelpers.compare(this.in.buffer, this.in.start, this.in.end, tmp.getBytes(), 0, tmp.getLength());
                boolean bl = swap = cmp == -1;
            }
            if (swap) {
                int inputLength = this.in.end - this.in.start;
                if (tmp.getLength() >= inputLength) {
                    this.in.buffer.getBytes(this.in.start, tmp.getBytes(), 0, inputLength);
                    tmp.setLength(inputLength);
                } else {
                    byte[] tempArray = new byte[this.in.end - this.in.start];
                    this.in.buffer.getBytes(this.in.start, tempArray, 0, this.in.end - this.in.start);
                    tmp.setBytes(tempArray);
                }
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                DrillByteArray tmp = (DrillByteArray)this.value.obj;
                this.buf = this.buf.reallocIfNeeded(tmp.getLength());
                this.buf.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
                this.out.start = 0;
                this.out.end = tmp.getLength();
                this.out.buffer = this.buf;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = new DrillByteArray();
            this.init.value = 0;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="min", returnType=FunctionTemplate.ReturnType.SAME_IN_OUT_LENGTH, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarCharMin
    implements DrillAggFunc {
        @Param
        NullableVarCharHolder in;
        @Workspace
        ObjectHolder value;
        @Workspace
        UInt1Holder init;
        @Workspace
        BigIntHolder nonNullCount;
        @Inject
        DrillBuf buf;
        @Output
        NullableVarCharHolder out;

        @Override
        public void setup() {
            this.init = new UInt1Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.init.value = 0;
            this.value = new ObjectHolder();
            DrillByteArray tmp = new DrillByteArray();
            this.value.obj = tmp;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                DrillByteArray tmp = (DrillByteArray)this.value.obj;
                int cmp = 0;
                boolean swap = false;
                if (this.init.value == 0) {
                    this.init.value = 1;
                    swap = true;
                } else {
                    cmp = ByteFunctionHelpers.compare(this.in.buffer, this.in.start, this.in.end, tmp.getBytes(), 0, tmp.getLength());
                    boolean bl = swap = cmp == -1;
                }
                if (swap) {
                    int inputLength = this.in.end - this.in.start;
                    if (tmp.getLength() >= inputLength) {
                        this.in.buffer.getBytes(this.in.start, tmp.getBytes(), 0, inputLength);
                        tmp.setLength(inputLength);
                    } else {
                        byte[] tempArray = new byte[this.in.end - this.in.start];
                        this.in.buffer.getBytes(this.in.start, tempArray, 0, this.in.end - this.in.start);
                        tmp.setBytes(tempArray);
                    }
                }
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                DrillByteArray tmp = (DrillByteArray)this.value.obj;
                this.buf = this.buf.reallocIfNeeded(tmp.getLength());
                this.buf.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
                this.out.start = 0;
                this.out.end = tmp.getLength();
                this.out.buffer = this.buf;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = new DrillByteArray();
            this.init.value = 0;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="min", returnType=FunctionTemplate.ReturnType.SAME_IN_OUT_LENGTH, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarCharMin
    implements DrillAggFunc {
        @Param
        VarCharHolder in;
        @Workspace
        ObjectHolder value;
        @Workspace
        UInt1Holder init;
        @Workspace
        BigIntHolder nonNullCount;
        @Inject
        DrillBuf buf;
        @Output
        NullableVarCharHolder out;

        @Override
        public void setup() {
            this.init = new UInt1Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.init.value = 0;
            this.value = new ObjectHolder();
            DrillByteArray tmp = new DrillByteArray();
            this.value.obj = tmp;
        }

        @Override
        public void add() {
            this.nonNullCount.value = 1L;
            DrillByteArray tmp = (DrillByteArray)this.value.obj;
            int cmp = 0;
            boolean swap = false;
            if (this.init.value == 0) {
                this.init.value = 1;
                swap = true;
            } else {
                cmp = ByteFunctionHelpers.compare(this.in.buffer, this.in.start, this.in.end, tmp.getBytes(), 0, tmp.getLength());
                boolean bl = swap = cmp == -1;
            }
            if (swap) {
                int inputLength = this.in.end - this.in.start;
                if (tmp.getLength() >= inputLength) {
                    this.in.buffer.getBytes(this.in.start, tmp.getBytes(), 0, inputLength);
                    tmp.setLength(inputLength);
                } else {
                    byte[] tempArray = new byte[this.in.end - this.in.start];
                    this.in.buffer.getBytes(this.in.start, tempArray, 0, this.in.end - this.in.start);
                    tmp.setBytes(tempArray);
                }
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                DrillByteArray tmp = (DrillByteArray)this.value.obj;
                this.buf = this.buf.reallocIfNeeded(tmp.getLength());
                this.buf.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
                this.out.start = 0;
                this.out.end = tmp.getLength();
                this.out.buffer = this.buf;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = new DrillByteArray();
            this.init.value = 0;
            this.nonNullCount.value = 0L;
        }
    }
}

