/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.DrillByteArray;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

public class SingleValueVarBytesFunctions {

    @FunctionTemplate(name="single_value", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarBinarySingleValue
    implements DrillAggFunc {
        @Param
        NullableVarBinaryHolder in;
        @Workspace
        ObjectHolder value;
        @Workspace
        UInt1Holder init;
        @Workspace
        BigIntHolder nonNullCount;
        @Inject
        DrillBuf buf;
        @Output
        NullableVarBinaryHolder out;

        @Override
        public void setup() {
            this.init = new UInt1Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.init.value = 0;
            this.value = new ObjectHolder();
            DrillByteArray tmp = new DrillByteArray();
            this.value.obj = tmp;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                if (this.nonNullCount.value == 0L) {
                    this.nonNullCount.value = 1L;
                    int inputLength = this.in.end - this.in.start;
                    DrillByteArray tmp = (DrillByteArray)this.value.obj;
                    byte[] tempArray = new byte[inputLength];
                    this.in.buffer.getBytes(this.in.start, tempArray, 0, inputLength);
                    tmp.setBytes(tempArray);
                } else {
                    throw UserException.functionError().message("Input for single_value function has more than one row", new Object[0]).build();
                }
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                DrillByteArray tmp = (DrillByteArray)this.value.obj;
                this.buf = this.buf.reallocIfNeeded(tmp.getLength());
                this.buf.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
                this.out.start = 0;
                this.out.end = tmp.getLength();
                this.out.buffer = this.buf;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = new DrillByteArray();
            this.init.value = 0;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="single_value", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarBinarySingleValue
    implements DrillAggFunc {
        @Param
        VarBinaryHolder in;
        @Workspace
        ObjectHolder value;
        @Workspace
        UInt1Holder init;
        @Workspace
        BigIntHolder nonNullCount;
        @Inject
        DrillBuf buf;
        @Output
        NullableVarBinaryHolder out;

        @Override
        public void setup() {
            this.init = new UInt1Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.init.value = 0;
            this.value = new ObjectHolder();
            DrillByteArray tmp = new DrillByteArray();
            this.value.obj = tmp;
        }

        @Override
        public void add() {
            if (this.nonNullCount.value != 0L) {
                throw UserException.functionError().message("Input for single_value function has more than one row", new Object[0]).build();
            }
            this.nonNullCount.value = 1L;
            int inputLength = this.in.end - this.in.start;
            DrillByteArray tmp = (DrillByteArray)this.value.obj;
            byte[] tempArray = new byte[inputLength];
            this.in.buffer.getBytes(this.in.start, tempArray, 0, inputLength);
            tmp.setBytes(tempArray);
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                DrillByteArray tmp = (DrillByteArray)this.value.obj;
                this.buf = this.buf.reallocIfNeeded(tmp.getLength());
                this.buf.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
                this.out.start = 0;
                this.out.end = tmp.getLength();
                this.out.buffer = this.buf;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = new DrillByteArray();
            this.init.value = 0;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="single_value", returnType=FunctionTemplate.ReturnType.SAME_IN_OUT_LENGTH, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableVarCharSingleValue
    implements DrillAggFunc {
        @Param
        NullableVarCharHolder in;
        @Workspace
        ObjectHolder value;
        @Workspace
        UInt1Holder init;
        @Workspace
        BigIntHolder nonNullCount;
        @Inject
        DrillBuf buf;
        @Output
        NullableVarCharHolder out;

        @Override
        public void setup() {
            this.init = new UInt1Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.init.value = 0;
            this.value = new ObjectHolder();
            DrillByteArray tmp = new DrillByteArray();
            this.value.obj = tmp;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                if (this.nonNullCount.value == 0L) {
                    this.nonNullCount.value = 1L;
                    int inputLength = this.in.end - this.in.start;
                    DrillByteArray tmp = (DrillByteArray)this.value.obj;
                    byte[] tempArray = new byte[inputLength];
                    this.in.buffer.getBytes(this.in.start, tempArray, 0, inputLength);
                    tmp.setBytes(tempArray);
                } else {
                    throw UserException.functionError().message("Input for single_value function has more than one row", new Object[0]).build();
                }
            }
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                DrillByteArray tmp = (DrillByteArray)this.value.obj;
                this.buf = this.buf.reallocIfNeeded(tmp.getLength());
                this.buf.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
                this.out.start = 0;
                this.out.end = tmp.getLength();
                this.out.buffer = this.buf;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = new DrillByteArray();
            this.init.value = 0;
            this.nonNullCount.value = 0L;
        }
    }

    @FunctionTemplate(name="single_value", returnType=FunctionTemplate.ReturnType.SAME_IN_OUT_LENGTH, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class VarCharSingleValue
    implements DrillAggFunc {
        @Param
        VarCharHolder in;
        @Workspace
        ObjectHolder value;
        @Workspace
        UInt1Holder init;
        @Workspace
        BigIntHolder nonNullCount;
        @Inject
        DrillBuf buf;
        @Output
        NullableVarCharHolder out;

        @Override
        public void setup() {
            this.init = new UInt1Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.init.value = 0;
            this.value = new ObjectHolder();
            DrillByteArray tmp = new DrillByteArray();
            this.value.obj = tmp;
        }

        @Override
        public void add() {
            if (this.nonNullCount.value != 0L) {
                throw UserException.functionError().message("Input for single_value function has more than one row", new Object[0]).build();
            }
            this.nonNullCount.value = 1L;
            int inputLength = this.in.end - this.in.start;
            DrillByteArray tmp = (DrillByteArray)this.value.obj;
            byte[] tempArray = new byte[inputLength];
            this.in.buffer.getBytes(this.in.start, tempArray, 0, inputLength);
            tmp.setBytes(tempArray);
        }

        @Override
        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                DrillByteArray tmp = (DrillByteArray)this.value.obj;
                this.buf = this.buf.reallocIfNeeded(tmp.getLength());
                this.buf.setBytes(0, tmp.getBytes(), 0, tmp.getLength());
                this.out.start = 0;
                this.out.end = tmp.getLength();
                this.out.buffer = this.buf;
            } else {
                this.out.isSet = 0;
            }
        }

        @Override
        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = new DrillByteArray();
            this.init.value = 0;
            this.nonNullCount.value = 0L;
        }
    }
}

