/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import com.google.common.base.Charsets;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.joda.time.Period;

@FunctionTemplate(name="castEmptyStringNullableVarCharToNULLABLEINTERVAL", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL, isInternal=true)
public class CastEmptyStringNullableVarCharToNullableInterval
implements DrillSimpleFunc {
    @Param
    NullableVarCharHolder in;
    @Output
    NullableIntervalHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        if (this.in.isSet == 0 || this.in.end == this.in.start) {
            this.out.isSet = 0;
            return;
        }
        this.out.isSet = 1;
        byte[] buf = new byte[this.in.end - this.in.start];
        this.in.buffer.getBytes(this.in.start, buf, 0, this.in.end - this.in.start);
        String input = new String(buf, Charsets.UTF_8);
        Period period = Period.parse((String)input);
        this.out.months = period.getYears() * 12 + period.getMonths();
        this.out.days = period.getDays();
        this.out.milliseconds = period.getHours() * 3600000 + period.getMinutes() * 60000 + period.getSeconds() * 1000 + period.getMillis();
    }
}

