/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

@FunctionTemplate(name="castVARCHAR", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.STRING_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastIntervalYearToVarChar
implements DrillSimpleFunc {
    @Param
    IntervalYearHolder in;
    @Param
    BigIntHolder len;
    @Inject
    DrillBuf buffer;
    @Output
    VarCharHolder out;

    @Override
    public void setup() {
        this.buffer = this.buffer.reallocIfNeeded((int)this.len.value);
    }

    @Override
    public void eval() {
        int years = this.in.value / 12;
        int months = this.in.value % 12;
        String yearString = Math.abs(years) == 1 ? " year " : " years ";
        String monthString = Math.abs(months) == 1 ? " month " : " months ";
        StringBuilder str = new StringBuilder().append(years).append(yearString).append(months).append(monthString);
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.end = Math.min((int)this.len.value, str.length());
        this.out.buffer.setBytes(0, String.valueOf(str.substring(0, this.out.end)).getBytes(StandardCharsets.UTF_8));
    }
}

