/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import com.google.common.base.Charsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.DateUtility;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

@FunctionTemplate(names={"castTIME", "timetype"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, costCategory=FunctionTemplate.FunctionCostCategory.COMPLEX)
public class CastVarCharToTime
implements DrillSimpleFunc {
    @Param
    VarCharHolder in;
    @Output
    TimeHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        byte[] buf = new byte[this.in.end - this.in.start];
        this.in.buffer.getBytes(this.in.start, buf, 0, this.in.end - this.in.start);
        String input = new String(buf, Charsets.UTF_8);
        DateTimeFormatter f = DateUtility.getTimeFormatter();
        this.out.value = (int)LocalTime.parse(input, f).atDate(LocalDate.ofEpochDay(0L)).toInstant(ZoneOffset.UTC).toEpochMilli();
    }
}

