/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castDECIMAL28SPARSE", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastVarDecimalDecimal28Sparse
implements DrillSimpleFunc {
    @Param
    VarDecimalHolder in;
    @Inject
    DrillBuf buffer;
    @Param
    IntHolder precision;
    @Param
    IntHolder scale;
    @Output
    Decimal28SparseHolder out;

    @Override
    public void setup() {
        int size = 20;
        this.buffer = this.buffer.reallocIfNeeded(size);
    }

    @Override
    public void eval() {
        this.out.scale = this.scale.value;
        this.out.precision = this.precision.value;
        BigDecimal bd = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale).setScale(this.scale.value, RoundingMode.HALF_UP).round(new MathContext(this.precision.value, RoundingMode.HALF_UP));
        this.out.start = 0;
        this.out.buffer = this.buffer;
        DecimalUtility.getSparseFromBigDecimal(bd, this.out.buffer, this.out.start, this.out.scale, 5);
    }
}

