/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castVARCHAR", scope=FunctionTemplate.FunctionScope.SIMPLE, returnType=FunctionTemplate.ReturnType.STRING_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastVarDecimalVarChar
implements DrillSimpleFunc {
    @Param
    VarDecimalHolder in;
    @Param
    BigIntHolder len;
    @Inject
    DrillBuf buffer;
    @Output
    VarCharHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        BigDecimal bigDecimal = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale);
        String str = bigDecimal.toString();
        this.out.start = 0;
        this.out.end = Math.min((int)this.len.value, str.length());
        this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(this.out.end);
        this.out.buffer.setBytes(0, str.substring(0, this.out.end).getBytes(StandardCharsets.UTF_8));
    }
}

