/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import com.google.common.base.Charsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.DateUtility;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

@FunctionTemplate(name="castEmptyStringVarCharToNULLABLETIMESTAMP", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL, isInternal=true)
public class GCastVarCharToNullableTimeStamp
implements DrillSimpleFunc {
    @Param
    VarCharHolder in;
    @Output
    NullableTimeStampHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        if (this.in.end == this.in.start) {
            this.out.isSet = 0;
            return;
        }
        this.out.isSet = 1;
        byte[] buf = new byte[this.in.end - this.in.start];
        this.in.buffer.getBytes(this.in.start, buf, 0, this.in.end - this.in.start);
        String input = new String(buf, Charsets.UTF_8);
        LocalDateTime parsedDateTime = DateUtility.parseBest(input);
        this.out.value = parsedDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }
}

