/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.output;

import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.fn.FunctionAttributes;
import org.apache.drill.exec.expr.fn.FunctionUtils;
import org.apache.drill.exec.expr.fn.output.ReturnTypeInference;

public class ConcatReturnTypeInference
implements ReturnTypeInference {
    public static final ConcatReturnTypeInference INSTANCE = new ConcatReturnTypeInference();

    @Override
    public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
        TypeProtos.MajorType.Builder builder = TypeProtos.MajorType.newBuilder().setMinorType(attributes.getReturnValue().getType().getMinorType()).setMode(FunctionUtils.getReturnTypeDataMode(logicalExpressions, attributes));
        int totalPrecision = 0;
        for (LogicalExpression expression : logicalExpressions) {
            if (expression.getMajorType().hasPrecision()) {
                totalPrecision += expression.getMajorType().getPrecision();
                continue;
            }
            return builder.build();
        }
        return builder.setPrecision(totalPrecision > 65535 ? 65535 : totalPrecision).build();
    }
}

