/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.output;

import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.FunctionAttributes;
import org.apache.drill.exec.expr.fn.FunctionUtils;
import org.apache.drill.exec.expr.fn.output.ReturnTypeInference;
import org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import org.apache.drill.exec.planner.types.decimal.DecimalScalePrecisionAddFunction;
import org.apache.drill.exec.planner.types.decimal.DecimalScalePrecisionDivideFunction;
import org.apache.drill.exec.planner.types.decimal.DecimalScalePrecisionModFunction;
import org.apache.drill.exec.planner.types.decimal.DecimalScalePrecisionMulFunction;
import org.apache.drill.exec.util.DecimalUtility;

public class DecimalReturnTypeInference {

    public static class DecimalZeroScaleReturnTypeInference
    implements ReturnTypeInference {
        public static final DecimalZeroScaleReturnTypeInference INSTANCE = new DecimalZeroScaleReturnTypeInference();

        @Override
        public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
            int precision = 0;
            TypeProtos.DataMode mode = attributes.getReturnValue().getType().getMode();
            if (attributes.getNullHandling() == FunctionTemplate.NullHandling.NULL_IF_NULL) {
                for (LogicalExpression e : logicalExpressions) {
                    if (e.getMajorType().getMode() == TypeProtos.DataMode.OPTIONAL) {
                        mode = TypeProtos.DataMode.OPTIONAL;
                    }
                    precision = Math.max(precision, e.getMajorType().getPrecision());
                }
            }
            return TypeProtos.MajorType.newBuilder().setMinorType(attributes.getReturnValue().getType().getMinorType()).setScale(0).setPrecision(precision).setMode(mode).build();
        }
    }

    public static class DecimalSumScaleReturnTypeInference
    implements ReturnTypeInference {
        public static final DecimalSumScaleReturnTypeInference INSTANCE = new DecimalSumScaleReturnTypeInference();

        @Override
        public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
            TypeProtos.DataMode mode = FunctionUtils.getReturnTypeDataMode(logicalExpressions, attributes);
            assert (logicalExpressions.size() == 2);
            TypeProtos.MajorType leftMajorType = logicalExpressions.get(0).getMajorType();
            TypeProtos.MajorType rightMajorType = logicalExpressions.get(1).getMajorType();
            DecimalScalePrecisionMulFunction outputScalePrec = new DecimalScalePrecisionMulFunction(DecimalUtility.getDefaultPrecision(leftMajorType.getMinorType(), leftMajorType.getPrecision()), leftMajorType.getScale(), DecimalUtility.getDefaultPrecision(rightMajorType.getMinorType(), rightMajorType.getPrecision()), rightMajorType.getScale());
            return TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.VARDECIMAL).setScale(outputScalePrec.getOutputScale()).setPrecision(outputScalePrec.getOutputPrecision()).setMode(mode).build();
        }
    }

    public static class DecimalAvgAggReturnTypeInference
    implements ReturnTypeInference {
        public static final DecimalAvgAggReturnTypeInference INSTANCE = new DecimalAvgAggReturnTypeInference();

        @Override
        public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
            int scale = 0;
            TypeProtos.DataMode mode = FunctionUtils.getReturnTypeDataMode(logicalExpressions, attributes);
            for (LogicalExpression e : logicalExpressions) {
                scale = Math.max(scale, e.getMajorType().getScale());
            }
            return TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.VARDECIMAL).setScale(Math.min(Math.max(6, scale), DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericScale())).setPrecision(DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision()).setMode(mode).build();
        }
    }

    public static class DecimalSumAggReturnTypeInference
    implements ReturnTypeInference {
        public static final DecimalSumAggReturnTypeInference INSTANCE = new DecimalSumAggReturnTypeInference();

        @Override
        public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
            int scale = 0;
            TypeProtos.DataMode mode = FunctionUtils.getReturnTypeDataMode(logicalExpressions, attributes);
            for (LogicalExpression e : logicalExpressions) {
                scale = Math.max(scale, e.getMajorType().getScale());
            }
            return TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.VARDECIMAL).setScale(scale).setPrecision(DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision()).setMode(mode).build();
        }
    }

    public static class DecimalSetScaleReturnTypeInference
    implements ReturnTypeInference {
        public static final DecimalSetScaleReturnTypeInference INSTANCE = new DecimalSetScaleReturnTypeInference();

        @Override
        public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
            TypeProtos.DataMode mode = attributes.getReturnValue().getType().getMode();
            int scale = 0;
            int precision = 0;
            if (attributes.getNullHandling() == FunctionTemplate.NullHandling.NULL_IF_NULL) {
                for (LogicalExpression e : logicalExpressions) {
                    precision = Math.max(precision, e.getMajorType().getPrecision());
                    if (e.getMajorType().getMode() != TypeProtos.DataMode.OPTIONAL) continue;
                    mode = TypeProtos.DataMode.OPTIONAL;
                }
                assert (logicalExpressions.size() == 2 && logicalExpressions.get(1) instanceof ValueExpressions.IntExpression);
                scale = ((ValueExpressions.IntExpression)logicalExpressions.get(1)).getInt();
            }
            return TypeProtos.MajorType.newBuilder().setMinorType(attributes.getReturnValue().getType().getMinorType()).setScale(Math.max(scale, 0)).setPrecision(precision).setMode(mode).build();
        }
    }

    public static class DecimalModScaleReturnTypeInference
    implements ReturnTypeInference {
        public static final DecimalModScaleReturnTypeInference INSTANCE = new DecimalModScaleReturnTypeInference();

        @Override
        public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
            TypeProtos.DataMode mode = FunctionUtils.getReturnTypeDataMode(logicalExpressions, attributes);
            assert (logicalExpressions.size() == 2);
            TypeProtos.MajorType leftMajorType = logicalExpressions.get(0).getMajorType();
            TypeProtos.MajorType rightMajorType = logicalExpressions.get(1).getMajorType();
            DecimalScalePrecisionModFunction outputScalePrec = new DecimalScalePrecisionModFunction(DecimalUtility.getDefaultPrecision(leftMajorType.getMinorType(), leftMajorType.getPrecision()), leftMajorType.getScale(), DecimalUtility.getDefaultPrecision(rightMajorType.getMinorType(), rightMajorType.getPrecision()), rightMajorType.getScale());
            return TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.VARDECIMAL).setScale(outputScalePrec.getOutputScale()).setPrecision(outputScalePrec.getOutputPrecision()).setMode(mode).build();
        }
    }

    public static class DecimalMaxScaleReturnTypeInference
    implements ReturnTypeInference {
        public static final DecimalMaxScaleReturnTypeInference INSTANCE = new DecimalMaxScaleReturnTypeInference();

        @Override
        public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
            TypeProtos.DataMode mode = FunctionUtils.getReturnTypeDataMode(logicalExpressions, attributes);
            int scale = 0;
            int precision = 0;
            for (LogicalExpression e : logicalExpressions) {
                scale = Math.max(scale, e.getMajorType().getScale());
                precision = Math.max(precision, e.getMajorType().getPrecision());
            }
            return TypeProtos.MajorType.newBuilder().setMinorType(attributes.getReturnValue().getType().getMinorType()).setScale(scale).setPrecision(precision).setMode(mode).build();
        }
    }

    public static class DecimalDivScaleReturnTypeInference
    implements ReturnTypeInference {
        public static final DecimalDivScaleReturnTypeInference INSTANCE = new DecimalDivScaleReturnTypeInference();

        @Override
        public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
            TypeProtos.DataMode mode = FunctionUtils.getReturnTypeDataMode(logicalExpressions, attributes);
            assert (logicalExpressions.size() == 2);
            TypeProtos.MajorType leftMajorType = logicalExpressions.get(0).getMajorType();
            TypeProtos.MajorType rightMajorType = logicalExpressions.get(1).getMajorType();
            DecimalScalePrecisionDivideFunction outputScalePrec = new DecimalScalePrecisionDivideFunction(DecimalUtility.getDefaultPrecision(leftMajorType.getMinorType(), leftMajorType.getPrecision()), leftMajorType.getScale(), DecimalUtility.getDefaultPrecision(rightMajorType.getMinorType(), rightMajorType.getPrecision()), rightMajorType.getScale());
            return TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.VARDECIMAL).setScale(outputScalePrec.getOutputScale()).setPrecision(outputScalePrec.getOutputPrecision()).setMode(mode).build();
        }
    }

    public static class DecimalCastReturnTypeInference
    implements ReturnTypeInference {
        public static final DecimalCastReturnTypeInference INSTANCE = new DecimalCastReturnTypeInference();

        @Override
        public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
            TypeProtos.DataMode mode = FunctionUtils.getReturnTypeDataMode(logicalExpressions, attributes);
            if (logicalExpressions.size() != 3) {
                StringBuilder err = new StringBuilder();
                for (int i = 0; i < logicalExpressions.size(); ++i) {
                    err.append("arg").append(i).append(": ").append(logicalExpressions.get(i).getMajorType().getMinorType());
                }
                throw new DrillRuntimeException("Decimal cast function invoked with incorrect arguments" + err);
            }
            int scale = ((ValueExpressions.IntExpression)logicalExpressions.get(logicalExpressions.size() - 1)).getInt();
            int precision = ((ValueExpressions.IntExpression)logicalExpressions.get(logicalExpressions.size() - 2)).getInt();
            return TypeProtos.MajorType.newBuilder().setMinorType(attributes.getReturnValue().getType().getMinorType()).setScale(scale).setPrecision(precision).setMode(mode).build();
        }
    }

    public static class DecimalAggReturnTypeInference
    implements ReturnTypeInference {
        public static final DecimalAggReturnTypeInference INSTANCE = new DecimalAggReturnTypeInference();

        @Override
        public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
            int scale = 0;
            int precision = 0;
            TypeProtos.DataMode mode = FunctionUtils.getReturnTypeDataMode(logicalExpressions, attributes);
            for (LogicalExpression e : logicalExpressions) {
                scale = Math.max(scale, e.getMajorType().getScale());
                precision = Math.max(precision, e.getMajorType().getPrecision());
            }
            return TypeProtos.MajorType.newBuilder().setMinorType(attributes.getReturnValue().getType().getMinorType()).setScale(scale).setPrecision(precision).setMode(mode).build();
        }
    }

    public static class DecimalAddReturnTypeInference
    implements ReturnTypeInference {
        public static final DecimalAddReturnTypeInference INSTANCE = new DecimalAddReturnTypeInference();

        @Override
        public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
            TypeProtos.DataMode mode = FunctionUtils.getReturnTypeDataMode(logicalExpressions, attributes);
            assert (logicalExpressions.size() == 2);
            TypeProtos.MajorType leftMajorType = logicalExpressions.get(0).getMajorType();
            TypeProtos.MajorType rightMajorType = logicalExpressions.get(1).getMajorType();
            DecimalScalePrecisionAddFunction outputScalePrec = new DecimalScalePrecisionAddFunction(DecimalUtility.getDefaultPrecision(leftMajorType.getMinorType(), leftMajorType.getPrecision()), leftMajorType.getScale(), DecimalUtility.getDefaultPrecision(rightMajorType.getMinorType(), rightMajorType.getPrecision()), rightMajorType.getScale());
            return TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.VARDECIMAL).setScale(outputScalePrec.getOutputScale()).setPrecision(outputScalePrec.getOutputPrecision()).setMode(mode).build();
        }
    }
}

