/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.output;

import java.util.HashSet;
import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.fn.FunctionAttributes;
import org.apache.drill.exec.expr.fn.FunctionUtils;
import org.apache.drill.exec.expr.fn.ValueReference;
import org.apache.drill.exec.expr.fn.output.ReturnTypeInference;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;

public class DefaultReturnTypeInference
implements ReturnTypeInference {
    public static final DefaultReturnTypeInference INSTANCE = new DefaultReturnTypeInference();

    @Override
    public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
        if (attributes.getReturnValue().getType().getMinorType() == TypeProtos.MinorType.UNION) {
            HashSet<TypeProtos.MinorType> subTypes = Sets.newHashSet();
            for (ValueReference ref : attributes.getParameters()) {
                subTypes.add(ref.getType().getMinorType());
            }
            TypeProtos.MajorType.Builder builder = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.UNION).setMode(TypeProtos.DataMode.OPTIONAL);
            for (TypeProtos.MinorType subType : subTypes) {
                if (subType == TypeProtos.MinorType.LATE) continue;
                builder.addSubType(subType);
            }
            return builder.build();
        }
        return attributes.getReturnValue().getType().toBuilder().setMode(FunctionUtils.getReturnTypeDataMode(logicalExpressions, attributes)).build();
    }
}

