/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.output;

import java.util.List;
import org.apache.drill.exec.expr.fn.output.OutputWidthCalculator;
import org.apache.drill.exec.physical.impl.project.OutputWidthExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputWidthCalculators {
    private static final Logger logger = LoggerFactory.getLogger(OutputWidthCalculators.class);

    private static int adjustOutputWidth(int outputSize, String prefix) {
        if (outputSize > 65535 || outputSize < 0) {
            logger.warn(prefix + " Output size for expressions is too large, setting to MAX_VARCHAR_LENGTH");
            outputSize = 65535;
        }
        return outputSize;
    }

    public static class DefaultOutputWidthCalculator
    implements OutputWidthCalculator {
        public static final DefaultOutputWidthCalculator INSTANCE = new DefaultOutputWidthCalculator();

        @Override
        public int getOutputWidth(List<OutputWidthExpression.FixedLenExpr> args) {
            int outputSize = OutputWidthCalculators.adjustOutputWidth(50, "DefaultOutputWidthCalculator:");
            return outputSize;
        }
    }

    public static class CloneOutputWidthCalculator
    implements OutputWidthCalculator {
        public static final CloneOutputWidthCalculator INSTANCE = new CloneOutputWidthCalculator();

        @Override
        public int getOutputWidth(List<OutputWidthExpression.FixedLenExpr> args) {
            int outputSize = 0;
            if (args == null || args.size() < 1) {
                throw new IllegalArgumentException();
            }
            outputSize = args.get(0).getDataWidth();
            outputSize = OutputWidthCalculators.adjustOutputWidth(outputSize, "CloneOutputWidthCalculator:");
            return outputSize;
        }
    }

    public static class ConcatOutputWidthCalculator
    implements OutputWidthCalculator {
        public static final ConcatOutputWidthCalculator INSTANCE = new ConcatOutputWidthCalculator();

        @Override
        public int getOutputWidth(List<OutputWidthExpression.FixedLenExpr> args) {
            int outputSize = 0;
            if (args == null || args.size() == 0) {
                throw new IllegalArgumentException();
            }
            for (OutputWidthExpression.FixedLenExpr expr : args) {
                outputSize += expr.getDataWidth();
            }
            outputSize = OutputWidthCalculators.adjustOutputWidth(outputSize, "ConcatOutputWidthCalculator:");
            return outputSize;
        }
    }
}

