/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.concurrent.AutoCloseableLock;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.registry.FunctionHolder;
import org.apache.drill.shaded.guava.com.google.common.collect.ArrayListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.ListMultimap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionRegistryHolder
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(FunctionRegistryHolder.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final AutoCloseableLock readLock = new AutoCloseableLock(this.readWriteLock.readLock());
    private final AutoCloseableLock writeLock = new AutoCloseableLock(this.readWriteLock.writeLock());
    private int version;
    private final Map<String, Map<String, Queue<String>>> jars;
    private final Map<String, Map<String, DrillFuncHolder>> functions = new ConcurrentHashMap<String, Map<String, DrillFuncHolder>>();

    public FunctionRegistryHolder() {
        this.jars = new ConcurrentHashMap<String, Map<String, Queue<String>>>();
    }

    public int getVersion() {
        try (AutoCloseables.Closeable lock = this.readLock.open();){
            int n = this.version;
            return n;
        }
    }

    public void addJars(Map<String, List<FunctionHolder>> newJars, int version) {
        try (AutoCloseables.Closeable lock = this.writeLock.open();){
            for (Map.Entry<String, List<FunctionHolder>> newJar : newJars.entrySet()) {
                String jarName = newJar.getKey();
                this.removeAllByJar(jarName);
                ConcurrentHashMap<String, Queue<String>> jar = new ConcurrentHashMap<String, Queue<String>>();
                this.jars.put(jarName, jar);
                this.addFunctions(jar, newJar.getValue());
            }
            this.version = version;
        }
    }

    public void removeJar(String jarName) {
        try (AutoCloseables.Closeable lock = this.writeLock.open();){
            this.removeAllByJar(jarName);
        }
    }

    public List<String> getAllJarNames() {
        try (AutoCloseables.Closeable lock = this.readLock.open();){
            ArrayList<String> arrayList = new ArrayList<String>(this.jars.keySet());
            return arrayList;
        }
    }

    public Map<String, List<FunctionHolder>> getAllJarsWithFunctionHolders() {
        HashMap<String, List<FunctionHolder>> allFunctionHoldersByJar = new HashMap<String, List<FunctionHolder>>();
        try (AutoCloseables.Closeable lock = this.readLock.open();){
            for (String jarName : this.jars.keySet()) {
                LinkedList<FunctionHolder> drillFuncHolderList = new LinkedList<FunctionHolder>();
                Map<String, Queue<String>> functionsInJar = this.jars.get(jarName);
                for (Map.Entry<String, Queue<String>> functionEntry : functionsInJar.entrySet()) {
                    String fnName = functionEntry.getKey();
                    Queue<String> fnSignatureList = functionEntry.getValue();
                    Map<String, DrillFuncHolder> functionHolders = this.functions.get(fnName);
                    for (Map.Entry<String, DrillFuncHolder> entry : functionHolders.entrySet()) {
                        if (!fnSignatureList.contains(entry.getKey())) continue;
                        drillFuncHolderList.add(new FunctionHolder(fnName, entry.getKey(), entry.getValue()));
                    }
                }
                allFunctionHoldersByJar.put(jarName, drillFuncHolderList);
            }
        }
        return allFunctionHoldersByJar;
    }

    public List<String> getFunctionNamesByJar(String jarName) {
        try (AutoCloseables.Closeable lock = this.readLock.open();){
            Map<String, Queue<String>> functions = this.jars.get(jarName);
            ArrayList<String> arrayList = functions == null ? new ArrayList<String>() : new ArrayList<String>(functions.keySet());
            return arrayList;
        }
    }

    public ListMultimap<String, DrillFuncHolder> getAllFunctionsWithHolders(AtomicInteger version) {
        try (AutoCloseables.Closeable lock = this.readLock.open();){
            if (version != null) {
                version.set(this.version);
            }
            ArrayListMultimap<String, DrillFuncHolder> functionsWithHolders = ArrayListMultimap.create();
            for (Map.Entry<String, Map<String, DrillFuncHolder>> function : this.functions.entrySet()) {
                functionsWithHolders.putAll(function.getKey(), new ArrayList<DrillFuncHolder>(function.getValue().values()));
            }
            ArrayListMultimap<String, DrillFuncHolder> arrayListMultimap = functionsWithHolders;
            return arrayListMultimap;
        }
    }

    public ListMultimap<String, DrillFuncHolder> getAllFunctionsWithHolders() {
        return this.getAllFunctionsWithHolders(null);
    }

    public ListMultimap<String, String> getAllFunctionsWithSignatures() {
        try (AutoCloseables.Closeable lock = this.readLock.open();){
            ArrayListMultimap<String, String> functionsWithSignatures = ArrayListMultimap.create();
            for (Map.Entry<String, Map<String, DrillFuncHolder>> function : this.functions.entrySet()) {
                functionsWithSignatures.putAll(function.getKey(), new ArrayList<String>(function.getValue().keySet()));
            }
            ArrayListMultimap<String, String> arrayListMultimap = functionsWithSignatures;
            return arrayListMultimap;
        }
    }

    public List<DrillFuncHolder> getHoldersByFunctionName(String functionName, AtomicInteger version) {
        try (AutoCloseables.Closeable lock = this.readLock.open();){
            Map<String, DrillFuncHolder> holders;
            if (version != null) {
                version.set(this.version);
            }
            ArrayList<DrillFuncHolder> arrayList = (holders = this.functions.get(functionName)) == null ? new ArrayList<DrillFuncHolder>() : new ArrayList<DrillFuncHolder>(holders.values());
            return arrayList;
        }
    }

    public List<DrillFuncHolder> getHoldersByFunctionName(String functionName) {
        return this.getHoldersByFunctionName(functionName, null);
    }

    public boolean containsJar(String jarName) {
        try (AutoCloseables.Closeable lock = this.readLock.open();){
            boolean bl = this.jars.containsKey(jarName);
            return bl;
        }
    }

    public int functionsSize() {
        try (AutoCloseables.Closeable lock = this.readLock.open();){
            int n = this.functions.size();
            return n;
        }
    }

    public String getJarNameByFunctionSignature(String functionName, String functionSignature) {
        try (AutoCloseables.Closeable lock = this.readLock.open();){
            for (Map.Entry<String, Map<String, Queue<String>>> jar : this.jars.entrySet()) {
                Queue<String> functionSignatures = jar.getValue().get(functionName);
                if (functionSignatures == null || !functionSignatures.contains(functionSignature)) continue;
                String string = jar.getKey();
                return string;
            }
        }
        return null;
    }

    private void addFunctions(Map<String, Queue<String>> jar, List<FunctionHolder> newFunctions) {
        for (FunctionHolder function : newFunctions) {
            String functionName = function.getName();
            Queue<String> jarFunctions = jar.get(functionName);
            if (jarFunctions == null) {
                jarFunctions = new ConcurrentLinkedQueue<String>();
                jar.put(functionName, jarFunctions);
            }
            String functionSignature = function.getSignature();
            jarFunctions.add(functionSignature);
            Map signatures = this.functions.computeIfAbsent(functionName, k -> new ConcurrentHashMap());
            signatures.put(functionSignature, function.getHolder());
        }
    }

    private void removeAllByJar(String jarName) {
        Map<String, Queue<String>> jar = this.jars.remove(jarName);
        if (jar == null) {
            return;
        }
        boolean isClosed = false;
        for (Map.Entry<String, Queue<String>> functionEntry : jar.entrySet()) {
            String function = functionEntry.getKey();
            Map<String, DrillFuncHolder> functionHolders = this.functions.get(function);
            Queue<String> functionSignatures = functionEntry.getValue();
            isClosed = !isClosed && this.closeClassLoader(function, functionSignatures);
            functionHolders.keySet().removeAll(functionSignatures);
            if (!functionHolders.isEmpty()) continue;
            this.functions.remove(function);
        }
    }

    @Override
    public void close() {
        try (AutoCloseables.Closeable lock = this.writeLock.open();){
            this.jars.forEach((jarName, jar) -> {
                block1: {
                    if ("built-in".equals(jarName)) break block1;
                    for (Map.Entry functionEntry : jar.entrySet()) {
                        if (this.closeClassLoader((String)functionEntry.getKey(), (Queue)functionEntry.getValue())) break;
                    }
                }
            });
        }
    }

    private boolean closeClassLoader(String functionName, Queue<String> functionSignatures) {
        return this.getDrillFuncHolder(functionName, functionSignatures).map(drillFuncHolder -> {
            ClassLoader classLoader = drillFuncHolder.getClassLoader();
            try {
                ((AutoCloseable)((Object)classLoader)).close();
            }
            catch (Exception e) {
                logger.warn("Problem during closing class loader", (Throwable)e);
            }
            return true;
        }).orElse(false);
    }

    private Optional<DrillFuncHolder> getDrillFuncHolder(String functionName, Queue<String> functionSignatures) {
        Map<String, DrillFuncHolder> functionHolders = this.functions.get(functionName);
        return functionSignatures.stream().map(functionHolders::get).filter(Objects::nonNull).findAny();
    }
}

