/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.sql.SqlOperator;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.common.scanner.persistence.AnnotatedClassDescriptor;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.exec.exception.FunctionValidationException;
import org.apache.drill.exec.exception.JarValidationException;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionConverter;
import org.apache.drill.exec.expr.fn.registry.FunctionHolder;
import org.apache.drill.exec.expr.fn.registry.FunctionRegistryHolder;
import org.apache.drill.exec.expr.fn.registry.JarScan;
import org.apache.drill.exec.planner.logical.DrillConstExecutor;
import org.apache.drill.exec.planner.sql.DrillOperatorTable;
import org.apache.drill.exec.planner.sql.DrillSqlAggOperator;
import org.apache.drill.exec.planner.sql.DrillSqlAggOperatorWithoutInference;
import org.apache.drill.exec.planner.sql.DrillSqlOperator;
import org.apache.drill.exec.planner.sql.DrillSqlOperatorWithoutInference;
import org.apache.drill.shaded.guava.com.google.common.collect.ArrayListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.ListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFunctionRegistry
implements AutoCloseable {
    public static final String BUILT_IN = "built-in";
    private static final Logger logger = LoggerFactory.getLogger(LocalFunctionRegistry.class);
    private static final String functionSignaturePattern = "%s(%s)";
    private static final ImmutableMap<String, Pair<Integer, Integer>> registeredFuncNameToArgRange = ImmutableMap.builder().put("CONCAT", Pair.of((Object)1, (Object)Integer.MAX_VALUE)).put("LENGTH", Pair.of((Object)1, (Object)2)).put("CONVERT_TO", Pair.of((Object)2, (Object)2)).put("CONVERT_FROM", Pair.of((Object)2, (Object)2)).put("FLATTEN", Pair.of((Object)1, (Object)1)).build();
    private final FunctionRegistryHolder registryHolder = new FunctionRegistryHolder();

    public LocalFunctionRegistry(ScanResult classpathScan) {
        this.validate(BUILT_IN, classpathScan);
        this.register(Lists.newArrayList(new JarScan(BUILT_IN, classpathScan, this.getClass().getClassLoader())), -2);
        if (logger.isTraceEnabled()) {
            StringBuilder allFunctions = new StringBuilder();
            for (DrillFuncHolder method : this.registryHolder.getAllFunctionsWithHolders().values()) {
                allFunctions.append(method.toString()).append("\n");
            }
            logger.trace("Registered functions: [\n{}]", (Object)allFunctions);
        }
    }

    public int getVersion() {
        return this.registryHolder.getVersion();
    }

    public List<String> validate(String jarName, ScanResult scanResult) {
        ArrayList<String> functions = Lists.newArrayList();
        FunctionConverter converter = new FunctionConverter();
        List<AnnotatedClassDescriptor> providerClasses = scanResult.getAnnotatedClasses(FunctionTemplate.class.getName());
        if (this.registryHolder.containsJar(jarName)) {
            throw new JarValidationException(String.format("Jar with %s name has been already registered", jarName));
        }
        ListMultimap<String, String> allFuncWithSignatures = this.registryHolder.getAllFunctionsWithSignatures();
        for (AnnotatedClassDescriptor func : providerClasses) {
            DrillFuncHolder holder = converter.getHolder(func, ClassLoader.getSystemClassLoader());
            if (holder != null) {
                String[] names;
                String functionInput = holder.getInputParameters();
                for (String name : names = holder.getRegisteredNames()) {
                    String functionName = name.toLowerCase();
                    String functionSignature = String.format(functionSignaturePattern, functionName, functionInput);
                    if (allFuncWithSignatures.get((Object)functionName).contains(functionSignature)) {
                        throw new FunctionValidationException(String.format("Found duplicated function in %s: %s", this.registryHolder.getJarNameByFunctionSignature(functionName, functionSignature), functionSignature));
                    }
                    if (holder.isAggregating() && !holder.isDeterministic()) {
                        throw new FunctionValidationException(String.format("Aggregate functions must be deterministic: %s", func.getClassName()));
                    }
                    functions.add(functionSignature);
                    allFuncWithSignatures.put(functionName, functionSignature);
                }
                continue;
            }
            logger.warn("Unable to initialize function for class {}", (Object)func.getClassName());
        }
        return functions;
    }

    public void register(List<JarScan> jars, int version) {
        HashMap<String, List<FunctionHolder>> newJars = new HashMap<String, List<FunctionHolder>>();
        for (JarScan jarScan : jars) {
            FunctionConverter converter = new FunctionConverter();
            List<AnnotatedClassDescriptor> providerClasses = jarScan.getScanResult().getAnnotatedClasses(FunctionTemplate.class.getName());
            ArrayList<FunctionHolder> functions = new ArrayList<FunctionHolder>();
            newJars.put(jarScan.getJarName(), functions);
            for (AnnotatedClassDescriptor func : providerClasses) {
                String[] names;
                DrillFuncHolder holder = converter.getHolder(func, jarScan.getClassLoader());
                if (holder == null) continue;
                String functionInput = holder.getInputParameters();
                for (String name : names = holder.getRegisteredNames()) {
                    String functionName = name.toLowerCase();
                    String functionSignature = String.format(functionSignaturePattern, functionName, functionInput);
                    functions.add(new FunctionHolder(functionName, functionSignature, holder));
                }
            }
        }
        this.registryHolder.addJars(newJars, version);
    }

    public void unregister(String jarName) {
        if (BUILT_IN.equals(jarName)) {
            logger.warn("Functions marked as built-in are not allowed to be unregistered.");
            return;
        }
        this.registryHolder.removeJar(jarName);
    }

    public List<String> getAllJarNames() {
        return this.registryHolder.getAllJarNames();
    }

    public int size() {
        return this.registryHolder.functionsSize();
    }

    public List<DrillFuncHolder> getMethods(String name, AtomicInteger version) {
        return this.registryHolder.getHoldersByFunctionName(name.toLowerCase(), version);
    }

    public List<DrillFuncHolder> getMethods(String name) {
        return this.registryHolder.getHoldersByFunctionName(name.toLowerCase());
    }

    public Map<String, List<FunctionHolder>> getAllJarsWithFunctionsHolders() {
        return this.registryHolder.getAllJarsWithFunctionHolders();
    }

    public void register(DrillOperatorTable operatorTable) {
        AtomicInteger versionHolder = new AtomicInteger();
        Map<String, Collection<DrillFuncHolder>> registeredFunctions = this.registryHolder.getAllFunctionsWithHolders(versionHolder).asMap();
        operatorTable.setFunctionRegistryVersion(versionHolder.get());
        this.registerOperatorsWithInference(operatorTable, registeredFunctions);
        this.registerOperatorsWithoutInference(operatorTable, registeredFunctions);
    }

    private void registerOperatorsWithInference(DrillOperatorTable operatorTable, Map<String, Collection<DrillFuncHolder>> registeredFunctions) {
        HashMap<String, DrillSqlOperator.DrillSqlOperatorBuilder> map = new HashMap<String, DrillSqlOperator.DrillSqlOperatorBuilder>();
        HashMap<String, DrillSqlAggOperator.DrillSqlAggOperatorBuilder> mapAgg = new HashMap<String, DrillSqlAggOperator.DrillSqlAggOperatorBuilder>();
        for (Map.Entry<String, Collection<DrillFuncHolder>> entry : registeredFunctions.entrySet()) {
            ArrayListMultimap functions = ArrayListMultimap.create();
            ArrayListMultimap aggregateFunctions = ArrayListMultimap.create();
            String name = entry.getKey().toUpperCase();
            boolean isDeterministic = true;
            boolean isNiladic = false;
            boolean isVarArg = false;
            for (DrillFuncHolder drillFuncHolder : entry.getValue()) {
                int paramCount = drillFuncHolder.getParamCount();
                if (drillFuncHolder.isAggregating()) {
                    aggregateFunctions.put((Object)paramCount, drillFuncHolder);
                } else {
                    Pair argNumberRange = registeredFuncNameToArgRange.containsKey(name) ? registeredFuncNameToArgRange.get(name) : Pair.of((Object)drillFuncHolder.getParamCount(), (Object)drillFuncHolder.getParamCount());
                    functions.put(argNumberRange, drillFuncHolder);
                }
                if (!drillFuncHolder.isDeterministic() || drillFuncHolder.isComplexWriterFuncHolder()) {
                    isDeterministic = false;
                }
                if (drillFuncHolder.isNiladic()) {
                    isNiladic = true;
                }
                if (!drillFuncHolder.isVarArg()) continue;
                isVarArg = true;
            }
            for (Map.Entry entry2 : functions.asMap().entrySet()) {
                Pair range = (Pair)entry2.getKey();
                int max = (Integer)range.getRight();
                int min = (Integer)range.getLeft();
                if (!map.containsKey(name)) {
                    map.put(name, new DrillSqlOperator.DrillSqlOperatorBuilder().setName(name));
                }
                DrillSqlOperator.DrillSqlOperatorBuilder drillSqlOperatorBuilder = (DrillSqlOperator.DrillSqlOperatorBuilder)map.get(name);
                drillSqlOperatorBuilder.addFunctions((Collection)entry2.getValue()).setVarArg(isVarArg).setArgumentCount(min, max).setDeterministic(isDeterministic).setNiladic(isNiladic);
            }
            for (Map.Entry entry3 : aggregateFunctions.asMap().entrySet()) {
                if (!mapAgg.containsKey(name)) {
                    mapAgg.put(name, new DrillSqlAggOperator.DrillSqlAggOperatorBuilder().setName(name));
                }
                DrillSqlAggOperator.DrillSqlAggOperatorBuilder drillSqlAggOperatorBuilder = (DrillSqlAggOperator.DrillSqlAggOperatorBuilder)mapAgg.get(name);
                drillSqlAggOperatorBuilder.addFunctions((Collection)entry3.getValue()).setArgumentCount((Integer)entry3.getKey(), (Integer)entry3.getKey());
            }
        }
        for (Map.Entry<String, Collection<DrillFuncHolder>> entry : map.entrySet()) {
            operatorTable.addOperatorWithInference(entry.getKey(), (SqlOperator)((DrillSqlOperator.DrillSqlOperatorBuilder)((Object)entry.getValue())).build());
        }
        for (Map.Entry<String, Collection<DrillFuncHolder>> entry : mapAgg.entrySet()) {
            operatorTable.addOperatorWithInference(entry.getKey(), (SqlOperator)((DrillSqlAggOperator.DrillSqlAggOperatorBuilder)((Object)entry.getValue())).build());
        }
    }

    private void registerOperatorsWithoutInference(DrillOperatorTable operatorTable, Map<String, Collection<DrillFuncHolder>> registeredFunctions) {
        for (Map.Entry<String, Collection<DrillFuncHolder>> function : registeredFunctions.entrySet()) {
            HashSet<Integer> argCounts = new HashSet<Integer>();
            String name = function.getKey().toUpperCase();
            for (DrillFuncHolder func : function.getValue()) {
                Object op;
                if (!argCounts.add(func.getParamCount())) continue;
                if (func.isAggregating()) {
                    op = new DrillSqlAggOperatorWithoutInference(name, func.getParamCount(), func.isVarArg());
                } else {
                    boolean isDeterministic = DrillConstExecutor.NON_REDUCIBLE_TYPES.contains(func.getReturnType().getMinorType()) || func.isComplexWriterFuncHolder() ? false : func.isDeterministic();
                    op = new DrillSqlOperatorWithoutInference(name, func.getParamCount(), func.getReturnType(), isDeterministic, func.isNiladic(), func.isVarArg());
                }
                operatorTable.addOperatorWithoutInference(function.getKey(), (SqlOperator)op);
            }
        }
    }

    @Override
    public void close() {
        this.registryHolder.close();
    }
}

