/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.metastore.analyze;

import java.util.Map;
import org.apache.calcite.sql.SqlKind;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.metastore.statistics.BaseStatisticsKind;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.StatisticsKind;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;

public class AnalyzeColumnUtils {
    private static final String COLUMN_SEPARATOR = "$";
    public static final Map<StatisticsKind<?>, SqlKind> COLUMN_STATISTICS_FUNCTIONS = ImmutableMap.builder().put(ColumnStatisticsKind.MAX_VALUE, SqlKind.MAX).put(ColumnStatisticsKind.MIN_VALUE, SqlKind.MIN).put(ColumnStatisticsKind.NON_NULL_VALUES_COUNT, SqlKind.COUNT).put((ColumnStatisticsKind<Long>)((Object)TableStatisticsKind.ROW_COUNT), SqlKind.COUNT).build();
    public static final Map<StatisticsKind<?>, TypeProtos.MinorType> COLUMN_STATISTICS_TYPES = ImmutableMap.builder().put(ColumnStatisticsKind.NON_NULL_VALUES_COUNT, TypeProtos.MinorType.BIGINT).put((ColumnStatisticsKind<Long>)((Object)TableStatisticsKind.ROW_COUNT), TypeProtos.MinorType.BIGINT).build();
    public static final Map<StatisticsKind<?>, SqlKind> META_STATISTICS_FUNCTIONS = ImmutableMap.builder().put(TableStatisticsKind.ROW_COUNT, SqlKind.COUNT).build();

    public static String getColumnName(String fullName) {
        return fullName.substring(fullName.indexOf(COLUMN_SEPARATOR, fullName.indexOf(COLUMN_SEPARATOR) + 1) + 1);
    }

    public static StatisticsKind<?> getStatisticsKind(String fullName) {
        String statisticsIdentifier;
        switch (statisticsIdentifier = fullName.split("\\$")[1]) {
            case "minValue": {
                return ColumnStatisticsKind.MIN_VALUE;
            }
            case "maxValue": {
                return ColumnStatisticsKind.MAX_VALUE;
            }
            case "nullsCount": {
                return ColumnStatisticsKind.NULLS_COUNT;
            }
            case "nonNullValuesCount": {
                return ColumnStatisticsKind.NON_NULL_VALUES_COUNT;
            }
            case "rowCount": {
                return TableStatisticsKind.ROW_COUNT;
            }
        }
        return new BaseStatisticsKind(statisticsIdentifier, false);
    }

    public static String getColumnStatisticsFieldName(String columnName, StatisticsKind<?> statisticsKind) {
        return String.format("column%1$s%2$s%1$s%3$s", COLUMN_SEPARATOR, statisticsKind.getName(), columnName);
    }

    public static String getMetadataStatisticsFieldName(StatisticsKind<?> statisticsKind) {
        return String.format("metadata%s%s", COLUMN_SEPARATOR, statisticsKind.getName());
    }

    public static boolean isColumnStatisticsField(String fieldName) {
        return fieldName.startsWith("column$");
    }

    public static boolean isMetadataStatisticsField(String fieldName) {
        return fieldName.startsWith("metadata$");
    }
}

