/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.metastore.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.calcite.rel.core.TableScan;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.metastore.ColumnNamesOptions;
import org.apache.drill.exec.metastore.analyze.AnalyzeInfoProvider;
import org.apache.drill.exec.metastore.analyze.FileMetadataInfoCollector;
import org.apache.drill.exec.metastore.analyze.MetadataInfoCollector;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.metastore.components.tables.BasicTablesRequests;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.TableInfo;

public abstract class AnalyzeFileInfoProvider
implements AnalyzeInfoProvider {
    @Override
    public List<SchemaPath> getSegmentColumns(DrillTable table, ColumnNamesOptions columnNamesOptions) throws IOException {
        FormatSelection selection = (FormatSelection)table.getSelection();
        FileSelection fileSelection = selection.getSelection();
        if (!fileSelection.isExpandedFully()) {
            fileSelection = FileMetadataInfoCollector.getExpandedFileSelection(fileSelection);
        }
        return ColumnExplorer.getPartitionColumnNames(fileSelection, columnNamesOptions).stream().map(SchemaPath::getSimplePath).collect(Collectors.toList());
    }

    @Override
    public List<SchemaPath> getProjectionFields(DrillTable table, MetadataType metadataLevel, ColumnNamesOptions columnNamesOptions) throws IOException {
        ArrayList<SchemaPath> projectionList = new ArrayList<SchemaPath>(this.getSegmentColumns(table, columnNamesOptions));
        projectionList.add(SchemaPath.getSimplePath(columnNamesOptions.fullyQualifiedName()));
        projectionList.add(SchemaPath.getSimplePath(columnNamesOptions.lastModifiedTime()));
        projectionList.add(SchemaPath.getSimplePath(columnNamesOptions.projectMetadataColumn()));
        return Collections.unmodifiableList(projectionList);
    }

    @Override
    public MetadataInfoCollector getMetadataInfoCollector(BasicTablesRequests basicRequests, TableInfo tableInfo, FormatSelection selection, PlannerSettings settings, Supplier<TableScan> tableScanSupplier, List<SchemaPath> interestingColumns, MetadataType metadataLevel, int segmentColumnsCount) throws IOException {
        return new FileMetadataInfoCollector(basicRequests, tableInfo, selection, settings, tableScanSupplier, interestingColumns, metadataLevel, segmentColumnsCount);
    }

    @Override
    public SchemaPath getLocationField(ColumnNamesOptions columnNamesOptions) {
        return SchemaPath.getSimplePath(columnNamesOptions.fullyQualifiedName());
    }

    @Override
    public NamedExpression getParentLocationExpression(SchemaPath locationField) {
        return new NamedExpression(new FunctionCall("parentPath", Collections.singletonList(locationField), ExpressionPosition.UNKNOWN), FieldReference.getWithQuotedRef("location"));
    }
}

