/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.metastore.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.metastore.ColumnNamesOptions;
import org.apache.drill.exec.metastore.analyze.AnalyzeFileInfoProvider;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.store.parquet.ParquetGroupScan;
import org.apache.drill.metastore.metadata.MetadataType;

public class AnalyzeParquetInfoProvider
extends AnalyzeFileInfoProvider {
    public static final AnalyzeParquetInfoProvider INSTANCE = new AnalyzeParquetInfoProvider();
    public static final String TABLE_TYPE_NAME = "PARQUET";

    @Override
    public List<SchemaPath> getProjectionFields(DrillTable table, MetadataType metadataLevel, ColumnNamesOptions columnNamesOptions) throws IOException {
        ArrayList<SchemaPath> columnList = new ArrayList<SchemaPath>(super.getProjectionFields(table, metadataLevel, columnNamesOptions));
        if (metadataLevel.includes(MetadataType.ROW_GROUP)) {
            columnList.add(SchemaPath.getSimplePath(columnNamesOptions.rowGroupIndex()));
            columnList.add(SchemaPath.getSimplePath(columnNamesOptions.rowGroupStart()));
            columnList.add(SchemaPath.getSimplePath(columnNamesOptions.rowGroupLength()));
        }
        return Collections.unmodifiableList(columnList);
    }

    @Override
    public boolean supportsGroupScan(GroupScan groupScan) {
        return groupScan instanceof ParquetGroupScan;
    }

    @Override
    public String getTableTypeName() {
        return TABLE_TYPE_NAME;
    }

    @Override
    public boolean supportsMetadataType(MetadataType metadataType) {
        switch (metadataType) {
            case ROW_GROUP: 
            case FILE: 
            case SEGMENT: 
            case TABLE: {
                return true;
            }
        }
        return false;
    }
}

