/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.metastore.store;

import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.metastore.store.SimpleFileTableMetadataProvider;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.schema.SchemaProvider;
import org.apache.drill.metastore.metadata.TableMetadataProvider;

public class FileSystemMetadataProviderManager
implements MetadataProviderManager {
    private SchemaProvider schemaProvider;
    private DrillStatsTable statsProvider;
    private TableMetadataProvider tableMetadataProvider;

    public static MetadataProviderManager init() {
        return new FileSystemMetadataProviderManager();
    }

    public static TableMetadataProvider getMetadataProviderForSchema(TupleMetadata schema) {
        return new SimpleFileTableMetadataProvider.Builder(new FileSystemMetadataProviderManager()).withSchema(schema).build();
    }

    public static TableMetadataProvider getMetadataProvider(MetadataProviderManager providerManager) {
        return providerManager == null ? new SimpleFileTableMetadataProvider.Builder(new FileSystemMetadataProviderManager()).build() : providerManager.getTableMetadataProvider();
    }

    @Override
    public void setSchemaProvider(SchemaProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    @Override
    public SchemaProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    @Override
    public void setStatsProvider(DrillStatsTable statsProvider) {
        this.statsProvider = statsProvider;
    }

    @Override
    public DrillStatsTable getStatsProvider() {
        return this.statsProvider;
    }

    @Override
    public void setTableMetadataProvider(TableMetadataProvider tableMetadataProvider) {
        this.tableMetadataProvider = tableMetadataProvider;
    }

    @Override
    public TableMetadataProvider getTableMetadataProvider() {
        return this.tableMetadataProvider;
    }

    @Override
    public boolean usesMetastore() {
        return false;
    }
}

