/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.metastore.store;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.metastore.store.FileTableMetadataProviderBuilder;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.schema.SchemaProvider;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.metastore.metadata.BaseTableMetadata;
import org.apache.drill.metastore.metadata.FileMetadata;
import org.apache.drill.metastore.metadata.MetadataInfo;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.NonInterestingColumnsMetadata;
import org.apache.drill.metastore.metadata.PartitionMetadata;
import org.apache.drill.metastore.metadata.SegmentMetadata;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.drill.metastore.metadata.TableMetadata;
import org.apache.drill.metastore.metadata.TableMetadataProvider;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFileTableMetadataProvider
implements TableMetadataProvider {
    private static final Logger logger = LoggerFactory.getLogger(SimpleFileTableMetadataProvider.class);
    private final TableMetadata tableMetadata;

    private SimpleFileTableMetadataProvider(TableMetadata tableMetadata) {
        this.tableMetadata = tableMetadata;
    }

    @Override
    public TableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    @Override
    public List<SchemaPath> getPartitionColumns() {
        return null;
    }

    @Override
    public List<PartitionMetadata> getPartitionsMetadata() {
        return null;
    }

    @Override
    public List<PartitionMetadata> getPartitionMetadata(SchemaPath columnName) {
        return null;
    }

    @Override
    public Map<Path, FileMetadata> getFilesMetadataMap() {
        return null;
    }

    @Override
    public Map<Path, SegmentMetadata> getSegmentsMetadataMap() {
        return null;
    }

    @Override
    public FileMetadata getFileMetadata(Path location) {
        return null;
    }

    @Override
    public List<FileMetadata> getFilesForPartition(PartitionMetadata partition) {
        return null;
    }

    @Override
    public NonInterestingColumnsMetadata getNonInterestingColumnsMetadata() {
        return new NonInterestingColumnsMetadata(Collections.emptyMap());
    }

    @Override
    public boolean checkMetadataVersion() {
        return false;
    }

    public static class Builder
    implements FileTableMetadataProviderBuilder<Builder> {
        private final MetadataProviderManager metadataProviderManager;
        private FileSelection selection;
        private TupleMetadata schema;

        public Builder(MetadataProviderManager source) {
            this.metadataProviderManager = source;
        }

        @Override
        public Builder withSchema(TupleMetadata schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public Builder withSelection(FileSelection selection) {
            this.selection = selection;
            return this;
        }

        @Override
        public Builder withFileSystem(DrillFileSystem fs) {
            return this;
        }

        @Override
        public TableMetadataProvider build() {
            SchemaProvider schemaProvider = this.metadataProviderManager.getSchemaProvider();
            TableMetadataProvider source = this.metadataProviderManager.getTableMetadataProvider();
            if (source == null) {
                DrillStatsTable statsProvider = this.metadataProviderManager.getStatsProvider();
                HashMap columnsStatistics = new HashMap();
                if (statsProvider != null) {
                    if (!statsProvider.isMaterialized()) {
                        statsProvider.materialize();
                    }
                    if (statsProvider.isMaterialized()) {
                        for (SchemaPath column : statsProvider.getColumns()) {
                            columnsStatistics.put(column, new ColumnStatistics(DrillStatsTable.getEstimatedColumnStats(statsProvider, column)));
                        }
                    }
                }
                Path selectionRoot = this.selection != null ? this.selection.getSelectionRoot() : null;
                TupleMetadata schema = null;
                if (this.schema == null && schemaProvider != null) {
                    try {
                        schema = schemaProvider.read().getSchema();
                    }
                    catch (IOException | IllegalArgumentException e) {
                        logger.warn("Unable to read schema from schema provider [{}]: {}.\nQuery execution will continue without using the schema.", (Object)selectionRoot, (Object)e.getMessage());
                        logger.trace("Error when reading the schema", (Throwable)e);
                    }
                }
                MetadataInfo metadataInfo = MetadataInfo.builder().type(MetadataType.TABLE).build();
                BaseTableMetadata tableMetadata = ((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)BaseTableMetadata.builder().tableInfo(TableInfo.UNKNOWN_TABLE_INFO)).metadataInfo(metadataInfo)).location(selectionRoot).schema(schema)).columnsStatistics(columnsStatistics)).metadataStatistics(DrillStatsTable.getEstimatedTableStats(statsProvider))).partitionKeys(Collections.emptyMap()).build();
                source = new SimpleFileTableMetadataProvider(tableMetadata);
                this.metadataProviderManager.setTableMetadataProvider(source);
            }
            return source;
        }
    }
}

