/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.oauth;

import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.exec.oauth.PersistentTokenRegistry;
import org.apache.drill.exec.oauth.TokenRegistry;
import org.apache.drill.exec.server.DrillbitContext;

public class OAuthTokenProvider
implements AutoCloseable {
    private static final String STORAGE_REGISTRY_PATH = "oauth_tokens";
    private final DrillbitContext context;
    private PersistentTokenRegistry oauthTokenRegistry;

    public OAuthTokenProvider(DrillbitContext context) {
        this.context = context;
    }

    public TokenRegistry getOauthTokenRegistry(String username) {
        if (this.oauthTokenRegistry == null) {
            this.initRemoteRegistries(username);
        }
        return this.oauthTokenRegistry;
    }

    private synchronized void initRemoteRegistries(String username) {
        String finalpath = StringUtils.isNotEmpty((CharSequence)username) ? "oauth_tokens/" + username : STORAGE_REGISTRY_PATH;
        if (this.oauthTokenRegistry == null) {
            this.oauthTokenRegistry = new PersistentTokenRegistry(this.context, finalpath);
        }
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.closeSilently(this.oauthTokenRegistry);
    }
}

