/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.oauth;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.exec.oauth.PersistentTokenRegistry;
import org.apache.drill.exec.oauth.Tokens;
import org.apache.drill.exec.store.sys.PersistentStore;

public class PersistentTokenTable
implements Tokens {
    public final String ACCESS_TOKEN_KEY = "access_token";
    public final String REFRESH_TOKEN_KEY = "refresh_token";
    public final String EXPIRES_IN_KEY = "expires_in";
    private final Map<String, String> tokens;
    private final String key;
    private final PersistentStore<PersistentTokenTable> store;

    @JsonCreator
    public PersistentTokenTable(@JsonProperty(value="tokens") Map<String, String> tokens, @JsonProperty(value="key") String key, @JacksonInject PersistentTokenRegistry.StoreProvider storeProvider) {
        this.tokens = tokens != null ? tokens : new HashMap();
        this.key = key;
        this.store = storeProvider.getStore();
    }

    @Override
    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @Override
    @JsonIgnore
    public String get(String token) {
        return this.tokens.get(token);
    }

    @Override
    @JsonIgnore
    public boolean put(String token, String value, boolean replace) {
        if (replace || !this.tokens.containsKey(token)) {
            this.tokens.put(token, value);
            this.store.put(this.key, this);
            return true;
        }
        return false;
    }

    @Override
    @JsonIgnore
    public String getAccessToken() {
        return this.get("access_token");
    }

    @Override
    @JsonIgnore
    public String getRefreshToken() {
        return this.get("refresh_token");
    }

    @Override
    @JsonIgnore
    public String getExpiresIn() {
        return this.get("expires_in");
    }

    @Override
    @JsonIgnore
    public void setExpiresIn(String expiresIn) {
        if (!this.tokens.containsKey("expires_in") || !expiresIn.equals(this.getAccessToken())) {
            this.put("expires_in", expiresIn, true);
        }
    }

    @Override
    @JsonIgnore
    public void setAccessToken(String token) {
        if (!this.tokens.containsKey("access_token") || !token.equals(this.getAccessToken())) {
            this.put("access_token", token, true);
        }
    }

    @Override
    @JsonIgnore
    public void setRefreshToken(String token) {
        if (!this.tokens.containsKey("refresh_token") || !this.getAccessToken().equals(token)) {
            this.put("refresh_token", token, true);
        }
    }

    @Override
    @JsonIgnore
    public boolean remove(String token) {
        boolean isRemoved = this.tokens.remove(token) != null;
        this.store.put(this.key, this);
        return isRemoved;
    }

    @JsonProperty(value="tokens")
    public Map<String, String> getTokens() {
        return this.tokens;
    }
}

