/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.ops;

import io.netty.buffer.ByteBuf;
import org.apache.drill.exec.ops.Consumer;
import org.apache.drill.exec.ops.SendingAccountor;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusHandler
implements RpcOutcomeListener<GeneralRPCProtos.Ack> {
    private static final Logger logger = LoggerFactory.getLogger(StatusHandler.class);
    private final SendingAccountor sendingAccountor;
    private final Consumer<RpcException> consumer;

    public StatusHandler(Consumer<RpcException> consumer, SendingAccountor sendingAccountor) {
        this.consumer = consumer;
        this.sendingAccountor = sendingAccountor;
    }

    @Override
    public void failed(RpcException ex) {
        this.sendingAccountor.decrement();
        this.consumer.accept(ex);
    }

    @Override
    public void success(GeneralRPCProtos.Ack value, ByteBuf buffer) {
        this.sendingAccountor.decrement();
        if (value.getOk()) {
            return;
        }
        logger.error("Data not accepted downstream. Stopping future sends.");
        this.consumer.accept(new RpcException("Data not accepted downstream."));
    }

    @Override
    public void interrupted(InterruptedException e) {
        this.sendingAccountor.decrement();
        this.consumer.interrupt(e);
    }
}

