/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical;

import com.google.protobuf.TextFormat;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointAffinity {
    static final Logger logger = LoggerFactory.getLogger(EndpointAffinity.class);
    private final CoordinationProtos.DrillbitEndpoint endpoint;
    private double affinity = 0.0;
    private boolean mandatory;
    private int maxWidth = Integer.MAX_VALUE;

    public EndpointAffinity(CoordinationProtos.DrillbitEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public EndpointAffinity(CoordinationProtos.DrillbitEndpoint endpoint, double affinity) {
        this.endpoint = endpoint;
        this.affinity = affinity;
    }

    public EndpointAffinity(CoordinationProtos.DrillbitEndpoint endpoint, double affinity, boolean mandatory, int maxWidth) {
        Preconditions.checkArgument(maxWidth >= 1, "MaxWidth for given endpoint should be at least one.");
        this.endpoint = endpoint;
        this.affinity = affinity;
        this.mandatory = mandatory;
        this.maxWidth = maxWidth;
    }

    public CoordinationProtos.DrillbitEndpoint getEndpoint() {
        return this.endpoint;
    }

    public double getAffinity() {
        return this.affinity;
    }

    public void addAffinity(double f) {
        Preconditions.checkArgument(f >= 0.0, "Affinity should not be negative");
        if (Double.POSITIVE_INFINITY == f) {
            this.affinity = f;
        } else if (Double.POSITIVE_INFINITY != this.affinity) {
            this.affinity += f;
        }
    }

    public void setAssignmentRequired() {
        this.mandatory = true;
    }

    public boolean isAssignmentRequired() {
        return this.mandatory || Double.POSITIVE_INFINITY == this.affinity;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        Preconditions.checkArgument(maxWidth >= 1, "MaxWidth for given endpoint should be at least one.");
        this.maxWidth = Math.min(this.maxWidth, maxWidth);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.affinity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointAffinity)) {
            return false;
        }
        EndpointAffinity other = (EndpointAffinity)obj;
        if (Double.doubleToLongBits(this.affinity) != Double.doubleToLongBits(other.affinity)) {
            return false;
        }
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        return this.mandatory == other.mandatory;
    }

    public String toString() {
        return "EndpointAffinity [endpoint=" + TextFormat.shortDebugString(this.endpoint) + ", affinity=" + this.affinity + ", mandatory=" + this.mandatory + ", maxWidth=" + this.maxWidth + "]";
    }
}

