/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.drill.common.graph.GraphVisitor;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.cost.PrelCostEstimates;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public abstract class AbstractBase
implements PhysicalOperator {
    public static long INIT_ALLOCATION = 1000000L;
    public static long MAX_ALLOCATION = 10000000000L;
    protected long initialAllocation = INIT_ALLOCATION;
    protected long maxAllocation = MAX_ALLOCATION;
    protected final String userName;
    private int id;
    private PrelCostEstimates cost = PrelCostEstimates.ZERO_COST;

    public AbstractBase() {
        this.userName = null;
    }

    public AbstractBase(String userName) {
        this.userName = userName;
    }

    public AbstractBase(AbstractBase that) {
        Preconditions.checkNotNull(that, "Unable to clone: source is null.");
        this.userName = that.userName;
    }

    @Override
    public void accept(GraphVisitor<PhysicalOperator> visitor) {
        visitor.enter(this);
        if (this.iterator() == null) {
            throw new IllegalArgumentException("Null iterator for pop." + this);
        }
        for (PhysicalOperator o : this) {
            Preconditions.checkNotNull(o, String.format("Null in iterator for pop %s.", this));
            o.accept(visitor);
        }
        visitor.leave(this);
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public final void setOperatorId(int id) {
        this.id = id;
    }

    @Override
    public int getOperatorId() {
        return this.id;
    }

    @Override
    public BatchSchema.SelectionVectorMode getSVMode() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public long getInitialAllocation() {
        return this.initialAllocation;
    }

    @Override
    public PrelCostEstimates getCost() {
        return this.cost;
    }

    @Override
    public void setCost(PrelCostEstimates cost) {
        this.cost = cost;
    }

    @Override
    public long getMaxAllocation() {
        return this.maxAllocation;
    }

    @Override
    public void setMaxAllocation(long maxAllocation) {
        this.maxAllocation = maxAllocation;
    }

    @Override
    @JsonIgnore
    public boolean isBufferedOperator(QueryContext queryContext) {
        return false;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }
}

