/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractSingle;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.planner.fragment.ParallelizationInfo;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public abstract class AbstractExchange
extends AbstractSingle
implements Exchange {
    protected int senderMajorFragmentId;
    protected int receiverMajorFragmentId;
    protected List<CoordinationProtos.DrillbitEndpoint> senderLocations;
    protected List<CoordinationProtos.DrillbitEndpoint> receiverLocations;

    public AbstractExchange(PhysicalOperator child) {
        super(child);
    }

    @Override
    public boolean isExecutable() {
        return false;
    }

    @Override
    public ParallelizationInfo getSenderParallelizationInfo(List<CoordinationProtos.DrillbitEndpoint> receiverFragmentEndpoints) {
        return ParallelizationInfo.UNLIMITED_WIDTH_NO_ENDPOINT_AFFINITY;
    }

    @Override
    public ParallelizationInfo getReceiverParallelizationInfo(List<CoordinationProtos.DrillbitEndpoint> senderFragmentEndpoints) {
        Preconditions.checkArgument(senderFragmentEndpoints != null && senderFragmentEndpoints.size() > 0, "Sender fragment endpoint list should not be empty");
        return ParallelizationInfo.create(1, Integer.MAX_VALUE, AbstractExchange.getDefaultAffinityMap(senderFragmentEndpoints));
    }

    protected static List<EndpointAffinity> getDefaultAffinityMap(List<CoordinationProtos.DrillbitEndpoint> fragmentEndpoints) {
        HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> affinityMap = Maps.newHashMap();
        double affinityPerOccurrence = 1.0 / (double)fragmentEndpoints.size();
        for (CoordinationProtos.DrillbitEndpoint sender : fragmentEndpoints) {
            if (affinityMap.containsKey(sender)) {
                ((EndpointAffinity)affinityMap.get(sender)).addAffinity(affinityPerOccurrence);
                continue;
            }
            affinityMap.put(sender, new EndpointAffinity(sender, affinityPerOccurrence));
        }
        return new ArrayList<EndpointAffinity>(affinityMap.values());
    }

    protected void setupSenders(List<CoordinationProtos.DrillbitEndpoint> senderLocations) {
        this.senderLocations = ImmutableList.copyOf(senderLocations);
    }

    protected void setupReceivers(List<CoordinationProtos.DrillbitEndpoint> receiverLocations) throws PhysicalOperatorSetupException {
        this.receiverLocations = ImmutableList.copyOf(receiverLocations);
    }

    @Override
    public final void setupSenders(int majorFragmentId, List<CoordinationProtos.DrillbitEndpoint> senderLocations) throws PhysicalOperatorSetupException {
        this.senderMajorFragmentId = majorFragmentId;
        this.setupSenders(senderLocations);
    }

    @Override
    public final void setupReceivers(int majorFragmentId, List<CoordinationProtos.DrillbitEndpoint> receiverLocations) throws PhysicalOperatorSetupException {
        this.receiverMajorFragmentId = majorFragmentId;
        this.setupReceivers(receiverLocations);
    }

    @Override
    public final <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitExchange(this, value);
    }

    @Override
    public String getOperatorType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Exchange.ParallelizationDependency getParallelizationDependency() {
        return Exchange.ParallelizationDependency.RECEIVER_DEPENDS_ON_SENDER;
    }

    @Override
    public long getSenderMemory(int receivers, int senders) {
        return 0L;
    }

    @Override
    public long getReceiverMemory(int receivers, int senders) {
        return 0L;
    }
}

