/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.exec.physical.MinorFragmentEndpoint;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReceiver
extends AbstractBase
implements Receiver {
    static final Logger logger = LoggerFactory.getLogger(AbstractReceiver.class);
    private final int oppositeMajorFragmentId;
    private final List<MinorFragmentEndpoint> senders;
    private final boolean spooling;

    public AbstractReceiver(int oppositeMajorFragmentId, List<MinorFragmentEndpoint> senders, boolean spooling) {
        this.oppositeMajorFragmentId = oppositeMajorFragmentId;
        this.senders = ImmutableList.copyOf(senders);
        this.spooling = spooling;
    }

    @Override
    public Iterator<PhysicalOperator> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitReceiver(this, value);
    }

    @Override
    public final PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.isEmpty());
        return this;
    }

    @Override
    @JsonProperty(value="sender-major-fragment")
    public int getOppositeMajorFragmentId() {
        return this.oppositeMajorFragmentId;
    }

    @Override
    @JsonProperty(value="senders")
    public List<MinorFragmentEndpoint> getProvidingEndpoints() {
        return this.senders;
    }

    @JsonIgnore
    public int getNumSenders() {
        return this.senders.size();
    }

    @Override
    public boolean isSpooling() {
        return this.spooling;
    }
}

