/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ScanStats {
    public static final ScanStats TRIVIAL_TABLE = new ScanStats(GroupScanProperty.NO_EXACT_ROW_COUNT, 20.0, 1.0, 1.0);
    public static final ScanStats ZERO_RECORD_TABLE = new ScanStats(GroupScanProperty.EXACT_ROW_COUNT, 0.0, 1.0, 1.0);
    @JsonProperty
    private final GroupScanProperty groupScanProperty;
    @JsonProperty
    private final double recordCount;
    @JsonProperty
    private final double cpuCost;
    @JsonProperty
    private final double diskCost;

    @JsonCreator
    public ScanStats(@JsonProperty(value="groupScanProperty") GroupScanProperty groupScanProperty, @JsonProperty(value="recordCount") double recordCount, @JsonProperty(value="cpuCost") double cpuCost, @JsonProperty(value="diskCost") double diskCost) {
        this.groupScanProperty = groupScanProperty;
        this.recordCount = recordCount;
        this.cpuCost = cpuCost;
        this.diskCost = diskCost;
    }

    public GroupScanProperty getGroupScanProperty() {
        return this.groupScanProperty;
    }

    public double getRecordCount() {
        return this.recordCount;
    }

    public double getCpuCost() {
        return this.cpuCost;
    }

    public double getDiskCost() {
        return this.diskCost;
    }

    public String toString() {
        return "ScanStats{recordCount=" + this.recordCount + ", cpuCost=" + this.cpuCost + ", diskCost=" + this.diskCost + ", groupScanProperty=" + (Object)((Object)this.groupScanProperty) + '}';
    }

    public static enum GroupScanProperty {
        NO_EXACT_ROW_COUNT(false, false),
        EXACT_ROW_COUNT(true, true),
        ESTIMATED_TOTAL_COST(false, true);

        private boolean hasExactRowCount;
        private boolean hasExactColumnValueCount;

        private GroupScanProperty(boolean hasExactRowCount, boolean hasExactColumnValueCount) {
            this.hasExactRowCount = hasExactRowCount;
            this.hasExactColumnValueCount = hasExactColumnValueCount;
        }

        public boolean hasExactRowCount() {
            return this.hasExactRowCount;
        }

        public boolean hasExactColumnValueCount() {
            return this.hasExactColumnValueCount;
        }

        public boolean hasFullCost() {
            return this == ESTIMATED_TOTAL_COST;
        }
    }
}

