/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.AbstractFileGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.hadoop.fs.Path;

@JsonTypeName(value="schemaless-scan")
public class SchemalessScan
extends AbstractFileGroupScan
implements SubScan {
    private final Path selectionRoot;

    @JsonCreator
    public SchemalessScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="selectionRoot") Path selectionRoot, @JsonProperty(value="columns") List<SchemaPath> columns) {
        this(userName, selectionRoot);
    }

    public SchemalessScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="selectionRoot") Path selectionRoot) {
        super(userName);
        this.selectionRoot = selectionRoot;
    }

    public SchemalessScan(SchemalessScan that) {
        super(that);
        this.selectionRoot = that.selectionRoot;
    }

    @Override
    @JsonProperty
    public Path getSelectionRoot() {
        return this.selectionRoot;
    }

    @Override
    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
    }

    @Override
    public SubScan getSpecificScan(int minorFragmentId) {
        return this;
    }

    @Override
    public int getMaxParallelizationWidth() {
        return 1;
    }

    @Override
    public String getDigest() {
        return this.toString();
    }

    public String toString() {
        String pattern = "SchemalessScan [selectionRoot = %s]";
        return String.format(pattern, this.selectionRoot);
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.isEmpty());
        return new SchemalessScan(this);
    }

    @Override
    public GroupScan clone(List<SchemaPath> columns) {
        return this;
    }

    @Override
    public ScanStats getScanStats() {
        return ScanStats.ZERO_RECORD_TABLE;
    }

    @Override
    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return false;
    }

    @Override
    public boolean supportsPartitionFilterPushdown() {
        return false;
    }
}

